#ifndef MAINWIDGET_H
#define MAINWIDGET_H

#include <QWidget>
#include <QVBoxLayout>
#include <QLabel>

#include "matchdaybackend.h"
#include "match.h"
#include "scoretable.h"
#include "settingsdialog.h"
#include <phonon/mediaobject.h>
#include <phonon/audiooutput.h>


class MainWidget : public QWidget
{
    Q_OBJECT
public:
    explicit MainWidget(QWidget *parent = 0);

    void mousePressEvent(QMouseEvent* event);

public slots:
    void showSettingsDialog();

protected slots:
    void onBackendUpdateStarted(void);
    void onBackendUpdateFinished(int error);

    void onMatchAdded(Match* match);
    void onScoreChange();
    void onMatchStateChanged(Match::MatchState);

private:
    Phonon::MediaObject *m_mediaObject_tor;
    Phonon::MediaObject *m_mediaObject_pfeife;
    Phonon::AudioOutput *m_audioOutput_tor;
    Phonon::AudioOutput *m_audioOutput_pfeife;

    MatchDayBackend* m_backend;
    MatchDayModel*   m_datamodel;
    ScoreTable*      m_scoretbl;
    SettingsDialog*  m_settingsdlg;
    QSettings        m_settings;

    QVBoxLayout m_layout;
    QLabel      m_statuslbl;

private slots:
    void onSettingsAccepted(void);

};

#endif // MAINWIDGET_H
