#include <QSettings>
#include <QMouseEvent>
#include <QApplication>
#include <QProcess>

#include "mainwidget.h"
#include "backendkicker.h"
#include "matchdaymodel.h"
#include "settingsdialog.h"

MainWidget::MainWidget(QWidget *parent) :
    QWidget(parent),
    m_mediaObject_tor(new Phonon::MediaObject(this)),
    m_mediaObject_pfeife(new Phonon::MediaObject(this)),
    m_audioOutput_tor(new Phonon::AudioOutput(Phonon::MusicCategory, this)),
    m_audioOutput_pfeife(new Phonon::AudioOutput(Phonon::MusicCategory, this)),
    m_backend(new BackendKicker(this)),
    m_datamodel(new MatchDayModel(this, m_backend)),
    m_scoretbl(new ScoreTable(m_datamodel)),
    m_settingsdlg(new SettingsDialog()),
    m_settings(qApp->organizationName(), qApp->applicationName())
{
    QFont f;
    QPalette palette;

    this->hide();
    this->setAttribute(Qt::WA_TranslucentBackground);

    // label
    m_statuslbl.hide();
    m_statuslbl.setText(tr("BuLi Scores!"));
    f.setPixelSize(40);
    palette.setColor(QPalette::Background, QColor(0, 0, 0, 127));
    palette.setColor(QPalette::Foreground, QColor(255, 255, 255, 127));
    m_statuslbl.setPalette(palette);
    m_statuslbl.setAutoFillBackground(true);
    m_statuslbl.setBackgroundRole(QPalette::Background);
    m_statuslbl.setAlignment(Qt::AlignCenter);

    m_statuslbl.setGeometry(0, 0, 400, 200);
    m_statuslbl.setFont(f);

    // table
    m_layout.addWidget(&m_statuslbl);
    m_layout.addWidget(m_scoretbl);
    m_layout.setSizeConstraint(QLayout::SetFixedSize);
    this->setLayout(&m_layout);
    this->setSizePolicy(QSizePolicy::Fixed, QSizePolicy::Fixed);

    m_statuslbl.show();

    connect(m_settingsdlg, SIGNAL(accepted()),
            this, SLOT(onSettingsAccepted()));

    connect(m_backend, SIGNAL(updateFinished(int)),
            this, SLOT(onBackendUpdateFinished(int)));

    connect(m_backend, SIGNAL(updateStarted()),
            this, SLOT(onBackendUpdateStarted()));

    connect(m_backend, SIGNAL(matchAdded(Match*)),
           this, SLOT(onMatchAdded(Match*)));

    m_mediaObject_tor->setCurrentSource(Phonon::MediaSource("/usr/share/buliscores/tor.mp3"));
    m_mediaObject_pfeife->setCurrentSource(Phonon::MediaSource("/usr/share/buliscores/trillerpfeife.mp3"));

    Phonon::createPath(m_mediaObject_tor,     m_audioOutput_tor);
    Phonon::createPath(m_mediaObject_pfeife,  m_audioOutput_pfeife);
}

void MainWidget::mousePressEvent(QMouseEvent* event)
{
    qDebug() << "widget tapped";

    // only needed for testing on desktop
    if (event->button() == Qt::RightButton) {
        this->showSettingsDialog();
    } else {
//        qDebug() << "pfeife volume: " << m_audioOutput_pfeife->volume();
//        qDebug() << "tor volume: " << m_audioOutput_tor->volume();
//        qDebug() << "pfeife state: " << m_mediaObject_pfeife->state();
//        qDebug() << "tor state: " << m_mediaObject_pfeife->state();
//        m_mediaObject_pfeife->seek(0);
//        if (m_settings.value("Sounds", false).toBool()) {
//            m_mediaObject_pfeife->play();
//        }
//        m_mediaObject_tor->seek(0);
//        if (m_settings.value("Sounds", false).toBool()) {
//            m_mediaObject_tor->play();
//        }
//        qDebug() << "pfeife state 2: " << m_mediaObject_pfeife->state();
//        qDebug() << "tor state 2: " << m_mediaObject_pfeife->state();
    }
}

void MainWidget::onSettingsAccepted()
{
    m_backend->selectLeague(m_settings.value("League", "1. Bundesliga").toString());
}

void MainWidget::onBackendUpdateStarted()
{

}

void MainWidget::onBackendUpdateFinished(int)
{
    if (m_statuslbl.isHidden() == false) {
        this->hide();
        m_statuslbl.hide();
        m_scoretbl->show();
        this->show();
    }
}

void MainWidget::onMatchAdded(Match* match) {
    connect(match, SIGNAL(scoreChanged(int,int,int,int)),
            this, SLOT(onScoreChange()));

    connect(match, SIGNAL(stateChanged(Match::MatchState)),
            this, SLOT(onMatchStateChanged(Match::MatchState)));

    qDebug() << "Match (" << match->homeTeam() << " vs "
             << match->awayTeam() << ") : registering signals";
}

void MainWidget::onScoreChange()
{
    if (m_settings.value("Sounds", false).toBool()) {
        m_mediaObject_tor->seek(0);
        m_mediaObject_tor->play();
        qDebug() << "Playing sound: tor";
    }
}

void MainWidget::onMatchStateChanged(Match::MatchState)
{
    if (m_settings.value("Sounds", false).toBool()) {
        m_mediaObject_pfeife->seek(0);
        m_mediaObject_pfeife->play();
        qDebug() << "Playing sound: trillerpfeife";
    }
}

void MainWidget::showSettingsDialog()
{
    m_settingsdlg->show();
}

