#ifndef BACKENDKICKER_H
#define BACKENDKICKER_H

#include <QObject>
#include <QTimer>
#include <QNetworkAccessManager>
#include <QNetworkReply>

#include "matchdaybackend.h"

class BackendKicker : public MatchDayBackend
{
    Q_OBJECT

    // TODO clear matchlist on match day change!
public:
    explicit BackendKicker(QObject *parent = 0);

    Match*        getMatch(QString hometeam, QString awayteam, QDateTime date);
    QList<Match*> matchList();

    bool          selectLeague(QString league);
    void          setAutomaticUpdate(bool);

signals:
    void updateFinished(int);
    void updateStarted(void);

public slots:
    void update();

private:
    QList<Match*> m_matchlist;
    QString       m_URL;
    QDateTime     m_lastUpdate;
    QTimer        m_updateTimer;
    QNetworkAccessManager* m_netaccmgr;
    bool          m_initialUpdateDone;

    static const int INTERVAL_FAST;

    void parsePage (QString htmlstr);
    void parseScore(Match* match, QString scorehtml);
    int secsToNextGame(void);

private slots:
    void dlndFinished(QNetworkReply *reply);


};

#endif // BACKENDKICKER_H
