#ifndef MATCH_H
#define MATCH_H

#include <QIcon>
#include <QObject>
#include <QDateTime>

class Match : public QObject
{
    Q_OBJECT
    Q_PROPERTY(QDateTime date READ date)
    Q_PROPERTY(QDateTime lastHomeGoal READ lastHomeGoal)
    Q_PROPERTY(QDateTime lastAwayGoal READ lastAwayGoal)
    Q_PROPERTY(QIcon homeEmblem READ homeEmblem)
    Q_PROPERTY(QIcon awayEmblem READ awayEmblem)
    Q_PROPERTY(QString homeTeam READ homeTeam)
    Q_PROPERTY(QString awayTeam READ awayTeam)
    Q_PROPERTY(int homeScore READ homeScore)
    Q_PROPERTY(int homeScoreFH READ homeScoreFH)
    Q_PROPERTY(int awayScore READ awayScore)
    Q_PROPERTY(int awayScoreFH READ awayScoreFH)
    Q_PROPERTY(MatchState state READ state)

    Q_ENUMS(MatchState)

public:
    enum MatchState {
        NotStarted,
        FirstHalf,
        HalfTime,
        SecondHalf,
        ExtraTime,
        Finished
    };

private:
    QDateTime   m_lastHomeGoal;
    QDateTime   m_lastAwayGoal;
    QDateTime   m_date;
    QString     m_homeTeam;
    QString     m_awayTeam;
    QIcon       m_homeEmblem;
    QIcon       m_awayEmblem;
    int         m_homeScore;
    int         m_homeScoreFH;
    int         m_awayScore;
    int         m_awayScoreFH;
    MatchState  m_state;

    QIcon     getEmblemByName(QString team);

public:
    explicit Match(QString hometeam, QString awayteam, QDateTime date, QObject *parent = 0);

    QDateTime date() const {return m_date;}
    QDateTime lastHomeGoal() const {return m_lastHomeGoal;}
    QDateTime lastAwayGoal() const {return m_lastAwayGoal;}

    QString homeTeam() const {return m_homeTeam;}
    QString awayTeam() const {return m_awayTeam;}

    int homeScore() const {return m_homeScore;}
    int homeScoreFH() const {return m_homeScoreFH;}

    int awayScore() const {return m_awayScore;}
    int awayScoreFH() const {return m_awayScoreFH;}

    void setScore(int home, int away, bool notifyWatchers);

    QIcon homeEmblem() const {return m_homeEmblem;}
    QIcon awayEmblem() const {return m_awayEmblem;}

    MatchState state() const {return m_state;}
    void setState(MatchState state, bool notifyWatchers);

signals:
    void scoreChanged(int oldhomescore, int oldawayscore,
                      int homescore, int awayscore);
    void stateChanged(Match::MatchState state);


public slots:

};

#endif // MATCH_H
