#include <QSettings>

#include "settingsdialog.h"
#include "ui_settingsdialog.h"

SettingsDialog::SettingsDialog(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::SettingsDialog),
    settings(qApp->organizationName(), qApp->applicationName())
{
    QString league;

    ui->setupUi(this);

    league = settings.value("League", "1. Bundesliga").toString();
    if (league == ui->rbBL1->text()) {
        ui->rbBL1->setChecked(true);
    } else if (league == ui->rbBL2->text()) {
        ui->rbBL2->setChecked(true);
    } else if (league == ui->rbT3BL->text()) {
        ui->rbT3BL->setChecked(true);
    } else {
        ui->rbBL1->setChecked(true);
    }

    ui->cbPlaySound->setChecked(settings.value("Sounds", false).toBool());

    connect(ui->buttonBox, SIGNAL(accepted()), this, SLOT(onDlgAccepted()));
}

SettingsDialog::~SettingsDialog()
{
    delete ui;
}

void SettingsDialog::onDlgAccepted()
{
    settings.setValue("League", ui->buttonGroup->checkedButton()->text());
    settings.setValue("Sounds", ui->cbPlaySound->isChecked());
    this->accept();
}
