#ifndef MATCHDAYBACKEND_H
#define MATCHDAYBACKEND_H

#include <QObject>

#include "match.h"

/*
 * Pure virtual class serving as a common interface for backends
 * providing MatchDay Data
 */
class MatchDayBackend : public QObject
{
    Q_OBJECT
public:
    explicit MatchDayBackend(QObject *parent = 0);

public:

    virtual Match* getMatch(QString hometeam, QString awayteam, QDateTime date) = 0;
    virtual QList<Match*> matchList() = 0;

    virtual bool selectLeague(QString league) = 0;

signals:
    void matchAdded(Match* match);
    void updateFinished(int);
    void updateStarted(void);

public slots:
    virtual void update() = 0;
};

#endif // MATCHDAYBACKEND_H
