#include "match.h"

Match::Match(QString hometeam, QString awayteam, QDateTime date, QObject *parent) :
    QObject(parent)
{
    m_date = date;

    m_homeTeam = hometeam;
    m_awayTeam = awayteam;
    m_homeScore = -1;
    m_awayScore = -1;

    m_homeEmblem = getEmblemByName(hometeam);
    m_awayEmblem = getEmblemByName(awayteam);
}


// TODO write team class that allows more attributes
// and aliases for team names
QIcon Match::getEmblemByName(QString team)
{
    QIcon i;

    if (team == "Hannover 96") {
        i = QIcon(":/1.Bundesliga/images/teams/Bundesliga1/Hannover.png");
    } else if (team == "FC St. Pauli") {
        i = QIcon(":/1.Bundesliga/images/teams/Bundesliga1/St.Pauli.png");
    } else if (team == "Hamburger SV") {
        i = QIcon(":/1.Bundesliga/images/teams/Bundesliga1/Hamburg.png");
    } else if (team == "1. FC Kaiserslautern") {
        i = QIcon(":/1.Bundesliga/images/teams/Bundesliga1/Kaiserslautern.png");
    } else if (team == "1. FSV Mainz 05") {
        i = QIcon(":/1.Bundesliga/images/teams/Bundesliga1/Mainz.png");
    } else if (team == "1899 Hoffenheim") {
        i = QIcon(":/1.Bundesliga/images/teams/Bundesliga1/Hoffenheim.png");
    } else if (team == "Borussia M'gladbach") {
        i = QIcon(":/1.Bundesliga/images/teams/Bundesliga1/Moenchengladbach.png");
    } else if (team == "VfL Wolfsburg") {
        i = QIcon(":/1.Bundesliga/images/teams/Bundesliga1/Wolfsburg.png");
    } else if (team == "SC Freiburg") {
        i = QIcon(":/1.Bundesliga/images/teams/Bundesliga1/Freiburg.png");
    } else if (team == "1. FC Kln") {
        i = QIcon(":/1.Bundesliga/images/teams/Bundesliga1/Koeln.png");
    } else if (team == "1. FC Nrnberg") {
        i = QIcon(":/1.Bundesliga/images/teams/Bundesliga1/Nuernberg.png");
    } else if (team == "FC Schalke 04") {
        i = QIcon(":/1.Bundesliga/images/teams/Bundesliga1/Schalke.png");
    } else if (team == "VfB Stuttgart") {
        i = QIcon(":/1.Bundesliga/images/teams/Bundesliga1/Stuttgart.png");
    } else if (team == "Eintracht Frankfurt") {
        i = QIcon(":/1.Bundesliga/images/teams/Bundesliga1/Frankfurt.png");
    } else if (team == "Bayer Leverkusen") {
        i = QIcon(":/1.Bundesliga/images/teams/Bundesliga1/Leverkusen.png");
    } else if (team == "Werder Bremen") {
        i = QIcon(":/1.Bundesliga/images/teams/Bundesliga1/Bremen.png");
    } else if (team == "Borussia Dortmund") {
        i = QIcon(":/1.Bundesliga/images/teams/Bundesliga1/Dortmund.png");
    } else if (team == "Bayern Mnchen") {
        i = QIcon(":/1.Bundesliga/images/teams/Bundesliga1/Bayern.png");

        // 2. Bundesliga

    } else if (team == "Arminia Bielefeld") {
        i = QIcon(":/2.Bundesliga/images/teams/Bundesliga2/Bielefeld.png");
    } else if (team == "SpVgg Greuther Frth") {
        i = QIcon(":/2.Bundesliga/images/teams/Bundesliga2/GreutherFuerth.png");
    } else if (team == "FSV Frankfurt") {
        i = QIcon(":/2.Bundesliga/images/teams/Bundesliga2/Frankfurt.png");
    } else if (team == "Hertha BSC") {
        i = QIcon(":/2.Bundesliga/images/teams/Bundesliga2/HerthaBerlin.png");
    } else if (team == "Karlsruher SC") {
        i = QIcon(":/2.Bundesliga/images/teams/Bundesliga2/Karlsruhe.png");
    } else if (team == "Energie Cottbus") {
        i = QIcon(":/2.Bundesliga/images/teams/Bundesliga2/Cottbus.png");
    } else if (team == "Alemannia Aachen") {
        i = QIcon(":/2.Bundesliga/images/teams/Bundesliga2/Aachen.png");
    } else if (team == "Rot-Wei Oberhausen") {
        i = QIcon(":/2.Bundesliga/images/teams/Bundesliga2/Oberhausen.png");
    } else if (team == "Fortuna Dsseldorf") {
        i = QIcon(":/2.Bundesliga/images/teams/Bundesliga2/Duesseldorf.png");
    } else if (team == "1. FC Union Berlin") {
        i = QIcon(":/2.Bundesliga/images/teams/Bundesliga2/UnionBerlin.png");
    } else if (team == "Erzgebirge Aue") {
        i = QIcon(":/2.Bundesliga/images/teams/Bundesliga2/Aue.png");
    } else if (team == "SC Paderborn 07") {
        i = QIcon(":/2.Bundesliga/images/teams/Bundesliga2/Paderborn.png");
    } else if (team == "FC Ingolstadt 04") {
        i = QIcon(":/2.Bundesliga/images/teams/Bundesliga2/Ingolstadt.png");
    } else if (team == "1860 Mnchen") {
        i = QIcon(":/2.Bundesliga/images/teams/Bundesliga2/Muenchen.png");
    } else if (team == "VfL Bochum") {
        i = QIcon(":/2.Bundesliga/images/teams/Bundesliga2/Bochum.png");
    } else if (team == "VfL Osnabrck") {
        i = QIcon(":/2.Bundesliga/images/teams/Bundesliga2/Osnabrueck.png");
    } else if (team == "FC Augsburg") {
        i = QIcon(":/2.Bundesliga/images/teams/Bundesliga2/Augsburg.png");
    } else if (team == "MSV Duisburg") {
        i = QIcon(":/2.Bundesliga/images/teams/Bundesliga2/Duisburg.png");

        // tipp3Liga

    } else if (team == "Sturm Graz") {
        i = QIcon(":/tipp3Liga/images/teams/tipp3Liga/Graz.png");
    } else if (team == "Austria Wien") {
        i = QIcon(":/tipp3Liga/images/teams/tipp3Liga/AustriaWien.png");
    } else if (team == "SV Mattersburg") {
        i = QIcon(":/tipp3Liga/images/teams/tipp3Liga/Mattersburg.png");
    } else if (team == "RB Salzburg") {
        i = QIcon(":/tipp3Liga/images/teams/tipp3Liga/Salzburg.png");
    } else if (team == "LASK Linz") {
        i = QIcon(":/tipp3Liga/images/teams/tipp3Liga/Linz.png");
    } else if (team == "Rapid Wien") {
        i = QIcon(":/tipp3Liga/images/teams/tipp3Liga/RapidWien.png");
    } else if (team == "SV Ried") {
        i = QIcon(":/tipp3Liga/images/teams/tipp3Liga/Ried.png");
    } else if (team == "Kapfenberger SV") {
        i = QIcon(":/tipp3Liga/images/teams/tipp3Liga/Kapfenberg.png");
    } else if (team == "Wacker Innsbruck") {
        i = QIcon(":/tipp3Liga/images/teams/tipp3Liga/Innsbruck.png");
    } else if (team == "SC Wiener Neustadt") {
        i = QIcon(":/tipp3Liga/images/teams/tipp3Liga/WienerNeustadt.gif");
    } else {


        i = QIcon();
    }

    return i;
}

void Match::setScore(int home, int away, bool notifyWatchers)
{
    bool changed = false;
    int oldhomescore = m_homeScore;
    int oldawayscore = m_awayScore;

    if (m_homeScore != home) {
        m_homeScore = home;
        if (oldhomescore != -1) {
            m_lastHomeGoal = QDateTime::currentDateTime();
        }
        changed = true;
    }

    if (m_awayScore != away) {
        m_awayScore = away;
        if (oldawayscore != -1) {
            m_lastAwayGoal = QDateTime::currentDateTime();
        }
        changed = true;
    }

    if (changed && notifyWatchers) {
        emit scoreChanged(oldhomescore, oldawayscore,
                          home, away);
    }
}

void Match::setState(MatchState state, bool notifyWatchers) {
    if (m_state != state) {
        m_state = state;
        if (notifyWatchers) {
            emit stateChanged(state);
        }
    }
}
