#include <QSettings>
#include <QMouseEvent>
#include <QApplication>
#include <QProcess>

#include "mainwidget.h"
#include "backendkicker.h"
#include "matchdaymodel.h"
#include "settingsdialog.h"

MainWidget::MainWidget(QWidget *parent) :
    QWidget(parent),
    m_mediaObject_tor(new Phonon::MediaObject(this)),
    m_mediaObject_pfeife(new Phonon::MediaObject(this)),
    m_audioOutput_tor(new Phonon::AudioOutput(Phonon::MusicCategory, this)),
    m_audioOutput_pfeife(new Phonon::AudioOutput(Phonon::MusicCategory, this)),
    m_backend(new BackendKicker(this)),
    m_datamodel(new MatchDayModel(this, m_backend)),
    m_scoretbl(new ScoreTable(m_datamodel)),
    m_settingsdlg(new SettingsDialog(this)),
    m_settings(qApp->organizationName(), qApp->applicationName())
{
    QFont f;
    QPalette palette;

    this->hide();
    this->setAttribute(Qt::WA_TranslucentBackground);

    // label
    m_statuslbl.hide();
    m_statuslbl.setText(tr("BuLi Scores!"));
    f.setPixelSize(40);
    palette.setColor(QPalette::Background, QColor(0, 0, 0, 127));
    palette.setColor(QPalette::Foreground, QColor(255, 255, 255, 127));
    m_statuslbl.setPalette(palette);
    m_statuslbl.setAttribute(Qt::WA_TransparentForMouseEvents);
    m_statuslbl.setAutoFillBackground(true);
    m_statuslbl.setBackgroundRole(QPalette::Background);
    m_statuslbl.setAlignment(Qt::AlignCenter);

    m_statuslbl.setFont(f);

    // table
    m_statuslbl.show();

    this->setLayout(&m_layout);
    m_layout.addWidget(&m_statuslbl);
    m_layout.addWidget(m_scoretbl);

    connect(m_settingsdlg, SIGNAL(accepted()),
            this, SLOT(update()));

    connect(m_backend, SIGNAL(updateFinished(int)),
            this, SLOT(onBackendUpdateFinished(int)));

    connect(m_backend, SIGNAL(updateStarted()),
            this, SLOT(onBackendUpdateStarted()));

    connect(m_backend, SIGNAL(matchAdded(Match*)),
           this, SLOT(onMatchAdded(Match*)));

    m_mediaObject_tor->setCurrentSource(Phonon::MediaSource("/usr/share/buliscores/tor.wav"));
    m_mediaObject_pfeife->setCurrentSource(Phonon::MediaSource("/usr/share/buliscores/trillerpfeife.wav"));

    Phonon::createPath(m_mediaObject_tor,     m_audioOutput_tor);
    Phonon::createPath(m_mediaObject_pfeife,  m_audioOutput_pfeife);
}

// only needed for testing on desktop
void MainWidget::mousePressEvent(QMouseEvent* event)
{
    if (event->button() == Qt::RightButton) {
        this->showSettingsDialog();
    }
}

void MainWidget::update(void)
{
    m_backend->selectLeague(m_settings.value("League", "1. Bundesliga").toString());
}

void MainWidget::onBackendUpdateStarted()
{

}

void MainWidget::onBackendUpdateFinished(int error)
{
    if (error > 0) {
        m_statuslbl.setText(tr("Error occured\nRetry pending..."));
        m_statuslbl.show();
        m_scoretbl->hide();
    } else {
        m_scoretbl->show();
        m_statuslbl.hide();
    }
}

void MainWidget::onMatchAdded(Match* match) {
    connect(match, SIGNAL(scoreChanged(int,int,int,int)),
            this, SLOT(onScoreChange()));

    connect(match, SIGNAL(stateChanged(Match::MatchState)),
            this, SLOT(onMatchStateChanged(Match::MatchState)));
    qDebug() << "Match (" << match->homeTeam() << " vs "
             << match->awayTeam() << ") : registering signals";
}

void MainWidget::onScoreChange()
{
    m_mediaObject_tor->play();
    qDebug() << "Playing sound: tor";
}

void MainWidget::onMatchStateChanged(Match::MatchState)
{
    m_mediaObject_pfeife->play();
    qDebug() << "Playing sound: trillerpfeife";
}

void MainWidget::showSettingsDialog()
{
    m_settingsdlg->show();
}

