#include <QSettings>

#include "settingsdialog.h"
#include "ui_settingsdialog.h"

SettingsDialog::SettingsDialog(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::SettingsDialog),
    settings(qApp->organizationName(), qApp->applicationName())
{
    QString league;

    ui->setupUi(this);

    league = settings.value("League", "1. Bundesliga").toString();

    if (league == "1. Bundesliga") {
        ui->rbBL1->setChecked(true);
    } else if (league == "2. Bundesliga") {
        ui->rbBL2->setChecked(true);
    } else if (league == "tipp3 Bundesliga") {
        ui->rbT3BL->setChecked(true);
    } else {
        ui->rbBL1->setChecked(true);
    }

    connect(ui->buttonGroup, SIGNAL(buttonClicked(QAbstractButton*)),
            this, SLOT(onLeagueSelected(QAbstractButton*)));
}

SettingsDialog::~SettingsDialog()
{
    delete ui;
}

void SettingsDialog::onLeagueSelected(QAbstractButton* button)
{
    settings.setValue("League", button->text());
    this->accept();
}
