/****************************************************************************
**
** Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
** All rights reserved.
** Contact: Nokia Corporation (qt-info@nokia.com)
**
** This file is part of the examples of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:LGPL$
** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the Technology Preview License Agreement accompanying
** this package.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain additional
** rights.  These rights are described in the Nokia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** If you have questions regarding the use of this file, please contact
** Nokia at qt-info@nokia.com.
**
**
**
**
**
**
**
**
** $QT_END_LICENSE$
**
****************************************************************************/

#include "qmaemo5homescreenadaptor.h"
#include "backendkicker.h"

#include <QtGui>
#include <QFile>
#include <QTextStream>
#include <src/mainwidget.h>



void messageHandler(QtMsgType type, const char *msg)
{
    static QFile logfile;
    static QTextStream fw;
    static const QString LOGFILE_PATH = "/tmp/buliscores.log";
    static const QtMsgType LOGLEVEL = QtDebugMsg;
    QString out;

    if (type < LOGLEVEL) {
        return;
    }

    if (logfile.isOpen() == false) {
        logfile.setFileName(LOGFILE_PATH);
        if (logfile.open(QIODevice::Append) == true) {
            fw.setDevice((QIODevice*)&logfile);
            fw << "Logfile Opened: " << QDateTime::currentDateTime().toString();
        }
    }

    switch (type) {
    case QtDebugMsg:
        out = "%1   Debug: %2\n";
        break;
    case QtWarningMsg:
        out = "%1   Warning: %2\n";
        break;
    case QtCriticalMsg:
        out = "%1   Critical: %2\n";
        break;
    case QtFatalMsg:
        out = "%1   Fatal: %2\n";
        break;
    }

    out = out.arg(QDateTime::currentDateTime().toString(), msg);

    if (logfile.isOpen()) {
        fw << out;
        fw.flush();
    }
    printf("%s", out.toAscii().constData());

    if (type == QtFatalMsg) {
        abort();
    }
}

int main(int argc, char *argv[])
{
    // enforce native graphics system for now due to a bug in transparency handling
    // you can remove this line if you only target PR 1.2
    qInstallMsgHandler(messageHandler);
    QApplication::setGraphicsSystem("native");
    QApplication app(argc, argv);
    MainWidget mw;

    app.setApplicationName("Buli Scores");
    app.setApplicationVersion("0.1");
    app.setOrganizationName("David Solbach");


    mw.resize(400,250);

    QMaemo5HomescreenAdaptor *adaptor = new QMaemo5HomescreenAdaptor(&mw);
    adaptor->setSettingsAvailable(true);
    QObject::connect(adaptor, SIGNAL(settingsRequested()), &mw, SLOT(showSettingsDialog()));

    mw.show();
    app.exec();
}

