#include <QHeaderView>
#include <QDebug>
#include <QRect>

#include "scoretable.h"
#include "matchdaymodel.h"

ScoreTable::ScoreTable(MatchDayModel* model, QWidget *parent) :
    QTableView(parent)
{
    QPalette palette;

    this->hide();
    // data
    this->setModel(model);

    // behaviour
    this->setAttribute(Qt::WA_TransparentForMouseEvents);
    this->setSelectionMode(QAbstractItemView::NoSelection);

    // style
    palette.setColor(QPalette::Background, QColor(0, 0, 0, 200));

    this->verticalHeader()->hide();
    this->verticalHeader()->setResizeMode(QHeaderView::ResizeToContents);
    this->verticalHeader()->setMinimumSectionSize(1);
    this->horizontalHeader()->hide();
    this->horizontalHeader()->setResizeMode(QHeaderView::ResizeToContents);
    this->horizontalHeader()->setMinimumSectionSize(1);

    this->setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
    this->setVerticalScrollBarPolicy(Qt::ScrollBarAlwaysOff);

    this->setSizePolicy(QSizePolicy::Fixed, QSizePolicy::Fixed);
    this->setAttribute(Qt::WA_TranslucentBackground);
    this->viewport()->setAttribute(Qt::WA_TranslucentBackground);

    this->setShowGrid(false);
}

QSize ScoreTable::sizeHint() const
{
    QSize s;

    for (int i = 0; i < horizontalHeader()->count(); i++) {
        s.setWidth(s.width() + horizontalHeader()->sectionSize(i));
    }
    // add missing few pixels (from borders mabye?)
    // TODO: find better solution!
    s.setWidth(s.width());
    for (int i = 0; i < verticalHeader()->count(); i++) {
        s.setHeight(s.height() + verticalHeader()->sectionSize(i));
    }
    // add missing few pixels (from borders mabye?)
    // TODO: find better solution!
    s.setHeight(s.height() + 2);

    return s;
}

void ScoreTable::dataChanged(const QModelIndex &topLeft, const QModelIndex &bottomRight)
{
    // this will recalculate section sizes
    QTableView::dataChanged(topLeft, bottomRight);

    this->updateGeometry();
}


