#ifndef MATCHDAYMODEL_H
#define MATCHDAYMODEL_H

#include <QAbstractTableModel>
#include <QFontMetrics>
#include <QSettings>

#include "matchdaybackend.h"

class MatchDayModel : public QAbstractTableModel
{
    Q_OBJECT

    enum {
        Spacer = 0,
        MatchState,
        Spacer2,
        HomeIcon,
        HomeTeam,
        HomeScore,
        Seperator,
        AwayScore,
        AwayTeam,
        AwayIcon,
        Date
    };

private:
    QString          m_url;
    MatchDayBackend* m_backend;
    int              m_lastRowCount;
    QSettings        m_settings;


public:
    explicit MatchDayModel(QObject *parent, MatchDayBackend* backend);

    int rowCount(const QModelIndex& index) const;
    int columnCount(const QModelIndex& index) const;
    QVariant data(const QModelIndex& index, int role) const;

protected slots:
    void onUpdateFinished(int);

};

#endif // MATCHDAYMODEL_H
