#include "match.h"

Match::Match(QString hometeam, QString awayteam, QDateTime date, QObject *parent) :
    QObject(parent)
{
    m_date = date;
    m_lastevent = QDateTime::currentDateTime();

    m_homeTeam = hometeam;
    m_awayTeam = awayteam;
    m_homeScore = -1;
    m_awayScore = -1;

    m_homeEmblem = getEmblemByName(hometeam);
    m_awayEmblem = getEmblemByName(awayteam);
}


// TODO write team class that allows more attributes
// and aliases for team names
QIcon Match::getEmblemByName(QString team)
{
    QIcon i;

    if (team == "Hannover 96") {
        i = QIcon(":/Icons/Hannover.png");
    } else if (team == "FC St. Pauli") {
        i = QIcon(":/Icons/St.Pauli.png");
    } else if (team == "Hamburger SV") {
        i = QIcon(":/Icons/Hamburg.png");
    } else if (team == "1. FC Kaiserslautern") {
        i = QIcon(":/Icons/Kaiserslautern.png");
    } else if (team == "1. FSV Mainz 05") {
        i = QIcon(":/Icons/Mainz.png");
    } else if (team == "1899 Hoffenheim") {
        i = QIcon(":/Icons/Hoffenheim.png");
    } else if (team == "Borussia M'gladbach") {
        i = QIcon(":/Icons/Moenchengladbach.png");
    } else if (team == "VfL Wolfsburg") {
        i = QIcon(":/Icons/Wolfsburg.png");
    } else if (team == "SC Freiburg") {
        i = QIcon(":/Icons/Freiburg.png");
    } else if (team == "1. FC Kln") {
        i = QIcon(":/Icons/Koeln.png");
    } else if (team == "1. FC Nrnberg") {
        i = QIcon(":/Icons/Nuernberg.png");
    } else if (team == "FC Schalke 04") {
        i = QIcon(":/Icons/Schalke.png");
    } else if (team == "VfB Stuttgart") {
        i = QIcon(":/Icons/Stuttgart.png");
    } else if (team == "Eintracht Frankfurt") {
        i = QIcon(":/Icons/Frankfurt.png");
    } else if (team == "Bayer Leverkusen") {
        i = QIcon(":/Icons/Leverkusen.png");
    } else if (team == "Werder Bremen") {
        i = QIcon(":/Icons/Bremen.png");
    } else if (team == "Borussia Dortmund") {
        i = QIcon(":/Icons/Dortmund.png");
    } else if (team == "Bayern Mnchen") {
        i = QIcon(":/Icons/Bayern.png");
    } else {
        i = QIcon();
    }

    return i;
}

void Match::setScore(int home, int away, bool notifyWatchers)
{
    bool changed = false;
    int oldhomescore = m_homeScore;
    int oldawayscore = m_awayScore;

    if (m_homeScore != home) {
        m_homeScore = home;
        changed = true;
    }

    if (m_awayScore != away) {
        m_awayScore = away;
        changed = true;
    }

    if (changed) {
        m_lastevent = QDateTime::currentDateTime();
        if(notifyWatchers) {
            emit scoreChanged(oldhomescore, oldawayscore,
                              home, away);
        }
    }
}

void Match::setState(MatchState state, bool notifyWatchers) {
    if (m_state != state) {
        m_state = state;
        m_lastevent = QDateTime::currentDateTime();
        if (notifyWatchers) {
            emit stateChanged(state);
        }
    }
}
