/*Copyright (C) 1995-1998, 2000-2002, 2004-2006 Free Software Foundation, Inc.
  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published
  by the Free Software Foundation; either version 2, or (at your option)
  any later version.
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.
  You should have received a copy of the GNU General Public
  License along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301,
  USA.  */

#ifndef GAME_H
#define GAME_H

#include <QWidget>
#include <QLCDNumber>
#include <QLabel>

/* description of widget window */
class Game : public QWidget
{
Q_OBJECT

public:
    Game(QWidget *parent = 0); // class constructor

public slots:
    void addHit();	// +1 hit to score when killing a bug
    void addFail();     // -1 life when passing a bug
    void addLife();     // +1 life when catching medkit
    void beginCount();  // set default values of LCDs
signals:
    void gameOver();    // game over signal
    void newLevel();
private:
    /* widgets of window */
    QLCDNumber* score;
    QLCDNumber* lifesLeft;
    QLabel* hitsLabel;
    QLabel* lifesLeftLabel;

};
#endif
