#!/bin/bash

ADDITIONAL_PARAM="-rfakeroot"
if [ -z "${SBOX_DPKG_INST_ARCH}" ];
then
    ADDITIONAL_PARAM=""
fi

rm build.log &> /dev/null
for package in media-server media-tools media-server-plugins media-renderer
do
    echo "Building package $package..."

    cd $package
    if [ "${1}" == "2.6" ];
    then
	echo "WARNING: also generating for python-2.6"
	mv debian/control debian/control.bk
	mv debian/rules debian/rules.bk
	cp debian/control-python-2.6 debian/control
	cp debian/rules-2.6 debian/rules
    fi
    dpkg-buildpackage ${ADDITIONAL_PARAM} -sa -S &> ../build.log
    sudo rm -dr build &> /dev/null
    sudo rm -dr build-stamp &> /dev/null
    dh_clean

    if [ "${1}" == "2.6" ];
    then
	mv debian/control.bk debian/control
	mv debian/rules.bk debian/rules
    fi

    cd ..
    echo "Finished building $package"
done

# Build brisa-apps

echo "Building virtual brisa-apps package..."
dpkg-buildpackage ${ADDITIONAL_PARAM} -sa -S &> build.log
mv ../*.dsc . &> /dev/null
mv ../*.changes . &> /dev/null
mv ../*.tar.gz . &>/dev/null
mv ../*.deb . &> /dev/null

echo "Finished building packages"
