/*
    watchdogs.RX-51.c - Keep alive watchdogs on RX-51 - Nokia N900
    Copyright (C) 2010  Pali Rohár <pali.rohar@gmail.com>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

*/

#include <errno.h>
#include <fcntl.h>
#include <sched.h>
#include <signal.h>
#include <unistd.h>
#include <stdlib.h>
#include <sys/mman.h>
#include <sys/wait.h>

#define WD_1 "/dev/watchdog"
#define WD_2 "/dev/twl4030_wdt"

int wd_1 = -1;
int wd_2 = -1;
int lock = 0;
int running = 1;

void quit_loop(int event) {

	running = 0;
	(void)event;

}

void quit(int code) {

	if ( lock != 0 )
		munlockall();

	if ( wd_1 != -1 ) {

		write(wd_1, "V", 1);
		close(wd_1);

	}

	if ( wd_2 != -1 ) {

		write(wd_2, "V", 1);
		close(wd_2);

	}

	exit(code);

}

void loop() {

	while ( running ) {

		if ( write(wd_1, "\0", 1) < 0 )
			quit(errno);

		if ( write(wd_2, "\0", 1) < 0 )
			quit(errno);

		sleep(10);

	}

}

int main() {

	wd_1 = open(WD_1, O_WRONLY);

	if ( wd_1 == -1 )
		quit(errno);

	wd_2 = open(WD_2, O_WRONLY);

	if ( wd_2 == -1 )
		quit(errno);

	if ( signal(SIGTERM, quit_loop) == SIG_ERR )
		quit(1);

	if ( signal(SIGINT, quit_loop) == SIG_ERR )
		quit(1);

	lock = mlockall(MCL_CURRENT | MCL_FUTURE);

	if ( lock != 0 )
		quit(errno);

	struct sched_param sp;
	sp.sched_priority = 1;

	if ( sched_setscheduler(0, SCHED_RR, &sp) != 0 )
		quit(errno);

	int pid = fork();

	if ( pid < 0 )
		quit(errno);
	else if ( pid > 0 ) {

		if ( waitpid(pid, 0, 0) != pid )
			exit(errno);
		else
			exit(0);

	}

	pid = fork();

	if ( pid < 0 )
		quit(errno);
	else if ( pid > 0 )
		exit(0);

	setsid();
	close(0);
	close(1);
	close(2);

	loop();
	quit(0);

	return 0;

}
