# show onscreen boot menu
# modify default_root,root_dev,root_fstype,root_fsoptions variables

#  Copyright (C) 2006,2007,2008 Frantisek Dufka
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

# HW keys scancodes
# up 103 down 108 left 105 right 106 select 28
# esc 1 menu 62 home 63 fullscreen 64 plus 65 minus 66

PRODUCT=`awk '/product/ { print $2 }' /proc/component_version`

[ "$EVNAME" = "" ] && case $PRODUCT in SU-18) EVNAME=event1 ;; RX-34) EVNAME=event2 ;; RX-4[48]) EVNAME=event0 ;; RX-51) EVNAME=event1 ;; esac

if [ x$PRODUCT = x"RX-51" ]; then
	echo "On a RX-51, loading MMC drivers etc."
	cd /dev; /sbin/MAKEDEV input; cd /
	modprobe mmc_block
	modprobe mmc_core
	modprobe omap_hsmmc
	echo "Sleeping 2 to allow spin-up"
	sleep 2
	echo "Creating mmc devices.."
	for p in /sys/block/mmcblk*/mmcblk*p*/; do
		n=`basename $p`
		rm -f /dev/$n
		mknod /dev/$n b `cat $p/dev | sed "s/:/ /g"`
		ls -l /dev/$n
	done
fi

#wait 1 second for keyup event
GETKEY="/usr/sbin/evkey -u -t 1000 /dev/input/${EVNAME}"
T2S="${initfs_prefix}/usr/bin/text2screen"

KEY_ENTER=28
KEY_SELECT=96
KEY_UP=103
KEY_DOWN=108
KEY_MENU=62
KEY_HOME=63
KEY_ESC=1

# IP address for USB networking
USB_IP=192.168.10.1

MENU_TIMEOUT=30

#figure out mmc slot device names, http://bugs.maemo.org/show_bug.cgi?id=2747
INT_CARD=""
EXT_CARD=""
case $PRODUCT in
SU-18)
	[ -d /sys/block/mmcblk0 ] && EXT_CARD="mmcblk0"
	;;
RX-*)
	for i in mmcblk0 mmcblk1 ; do
	if [ -d /sys/block/$i ] ; then
	if [ -f /sys/block/$i/device/../slot_name ] ; then
		# 2.6.21/OS2008
		slot_name=/sys/block/$i/device/../slot_name
	else
		# 2.6.18/OS2007
		slot_name=$(expr substr $(basename $(readlink /sys/block/$i/device) ) 1 4)
		slot_name=/sys/block/$i/device/../mmc_host:${slot_name}/slot_name
	fi
	case `cat $slot_name` in
		internal) INT_CARD=$i ;;
		external) EXT_CARD=$i ;;
	esac
	fi
	done
	;;
esac

#define menu items
MENU_MIN=1

MENU_1_NAME="Internal flash"
MENU_1_ID="flash"

MENU_2_NAME="Internal MMC card, partition 2, ext2"
MENU_2_ID="immc2"
MENU_2_DEVICE="${INT_CARD}p2"
MENU_2_MODULES="mbcache ext2"
MENU_2_FSTYPE="ext2"
MENU_2_FSOPTIONS="noatime"
[ -d "/sys/block/${INT_CARD}/${MENU_2_DEVICE}" ] || MENU_2_NAME="(${MENU_2_NAME}) N/A"

MENU_3_NAME="External MMC card, partition 2, ext2"
MENU_3_ID="mmc2"
MENU_3_DEVICE="${EXT_CARD}p2"
MENU_3_MODULES="mbcache ext2"
MENU_3_FSTYPE="ext2"
MENU_3_FSOPTIONS="noatime"
[ -d "/sys/block/${EXT_CARD}/${MENU_3_DEVICE}" ] || MENU_3_NAME="(${MENU_3_NAME}) N/A"

MENU_4_NAME="USB hard drive"
MENU_4_ID="usb"

MENU_5_NAME="Power off (when not on charger)"
MENU_5_ID="off"

#change max if you add/remove items
MENU_MAX=5

# load menu customization
[ -f ${initfs_prefix}/bootmenu.conf ] && . ${initfs_prefix}/bootmenu.conf

MENU_IDX=$MENU_MIN

load_modules()
{
for mod in $* ; do
if [ -f $MODULE_PATH/${mod}.ko ]; then
insmod $MODULE_PATH/${mod}.ko
fi
done
}

transfer_to_linuxrc()
{
	root_dev="$1"

	[ -z "$root_dev" ] && return 1

	if [ -z $root_fstype ]; then
		mkdir -p /mnt/new_root
		if [ -z $root_fsoptions ]; then
			time mount /dev/$root_dev /mnt/new_root
		else
			time mount -o $root_fsoptions /dev/$root_dev /mnt/new_root
		fi
	else
		if [ -z $root_fsoptions ]; then
			time mount -t $root_fstype /dev/$root_dev /mnt/new_root
	    	else
			time mount -t $root_fstype -o $root_fsoptions /dev/$root_dev /mnt/new_root
		fi
	fi
	grep -q new_root /proc/mounts
	${T2S} -c
	${T2S} -s 2 -H center -y 20 -T 0 -t "Starting $2 from ${default_root} (${root_dev} ${root_fstype})..."
	cp /mnt/new_root/$2 /tmp/linuxrc
	chmod a+rx /tmp/linuxrc
	exec /tmp/linuxrc
	${T2S} -c
	${T2S} -s 2 -H center -y 20 -T 0 -t "Failed to start linuxrc"
	exec /sbin/init
}

set_usb_mode(){
case $PRODUCT in
SU-18)
	echo $1 >/sys/devices/platform/tahvo-usb/otg_mode
	;;
RX-*)
	echo $1 >/sys/devices/platform/musb_hdrc/mode
	;;
esac
}

usbnet(){
(
${T2S} -c
[ -c /dev/ptmx ] || mknod /dev/ptmx c 5 2
[ -d /dev/pts ] || mkdir /dev/pts
insmod /lib/modules/current/g_ether.ko
mount -t devpts devpts /dev/pts
ifconfig usb0 $USB_IP up
retutime -i #load system clock
y=20
${T2S} -s 2 -H center -y $y -T 0 -t "USB networking is up with IP $USB_IP"
if [ -x /usr/sbin/utelnetd ] ; then # start utelnetd
	/usr/sbin/utelnetd -l /bin/sh -d
	y=$((y+20)) ; ${T2S} -s 2 -H center -y $y -T 0 -t "telnet server started on port 23"
fi
if [ -x /usr/sbin/dropbear ] ; then # start dropbear
DBCONF=/etc/dropbear
if [ -f $DBCONF/dropbear_rsa_host_key ] ; then
	/usr/sbin/dropbear
	y=$((y+20)) ; ${T2S} -s 2 -H center -y $y -T 0 -t "ssh server started on port 22"
else
	DBCONF=/tmp
	y=$((y+20)) ; ${T2S} -s 2 -H center -y $y -T 0 -t "no ssh keys, generating, may take a while ..."
	/usr/sbin/dropbearkey -t rsa -f $DBCONF/dropbear_rsa_host_key
	/usr/sbin/dropbearkey -t dss -f $DBCONF/dropbear_dss_host_key
	/usr/sbin/dropbear -d $DBCONF/dropbear_dss_host_key -r $DBCONF/dropbear_rsa_host_key
	y=$((y+20)) ; ${T2S} -s 2 -H center -y $y -T 0 -t "ssh server started on port 22"
fi
fi
y=$((y+40)) ; ${T2S} -s 2 -H center -y $y -T 0 -t "Press Esc to disconnect and go back"
while true ; do
	key=`evkey -u -t 100000 /dev/input/${EVNAME}`
	[ "$key" = "$KEY_ESC" ] && break
# uncomment for booting with usb recovery shell still running
#	[ "$key" = "$KEY_MENU" ] && break
done
${T2S} -c
if [ "$key" = "$KEY_ESC" ] ; then
killall dropbear
killall utelnetd
#sleep 1
ifconfig usb0 down
umount /dev/pts
rmmod g_ether.ko
fi
) >>/tmp/usb_network.log 2>&1
} 		

menu_redraw(){
i=$MENU_MIN
y=100
while [ $i -le $MENU_MAX ] ; do
	eval label=\$MENU_${i}_NAME
	if [ $i = $MENU_IDX ] ; then t=0xffff ; b=0 ; else t=0 ; b=0xffff ; fi
	${T2S} -x 0 -y $y -w 800 -h 20 -c
	${T2S} -s 2 -x 40 -y $y -T $t -B $b -t " $label "
	i=$((i+1))
	y=$((y+30))
done
}

boot_message(){
${T2S} -c
${T2S} -s 2 -H center -y 20 -T 0 -t "Booting from ${default_root} (${root_dev} ${root_fstype})..."
}

menu_init(){
${T2S} -c
${T2S} -s 2 -H center -y 30 -T 0 -t "BOOT MENU"
y=440
if [ -x /usr/sbin/utelnetd -o -x /usr/sbin/dropbear ] ; then
	${T2S} -s 2 -H center -y 450 -T 0 -t "Press HOME key for USB network recovery mode"
	y=420
fi
${T2S} -s 2 -H center -y $y -T 0 -t "Press UP/DOWN to move, CENTER to select"
}

#menu_debug(){
#${T2S} -x 0 -y 380 -w 800 -h 20 -c
#${T2S} -s 2 -H center -y 380 -T 0 -t "$1"
#}

timeout_redraw(){
${T2S} -x 760 -y 10 -w 40 -h 20 -c
[ $1 -ge 0 ] && ${T2S} -s 2 -x 760 -y 10 -T 0 -t "$1"
}

menu_loop(){
i=$MENU_TIMEOUT
key_pressed=0
while true ; do
key=`$GETKEY`
[ "$key" = "" ] || key_pressed=1
if [ $key_pressed = 0 ] ; then # handle menu timeout
	if [ $i -eq 0 ] ; then
		break # exit menu loop
	fi
	[ $i -gt 0 ] && i=$((i-1))
else
	i=-1
fi
timeout_redraw $i

case "$key" in
	${KEY_SELECT}) # select N810 key, exit menu
		break # exit menu loop
	;;
	${KEY_ENTER}) # enter/select key, exit menu
		break # exit menu loop
	;;
	${KEY_UP}) # up key
		if [ $MENU_IDX -gt $MENU_MIN ] ; then MENU_IDX=$((MENU_IDX-1)) ; else MENU_IDX=$MENU_MAX; fi
		menu_redraw
	;;
	${KEY_DOWN}) # down key
		if [ $MENU_IDX -lt $MENU_MAX ] ; then MENU_IDX=$((MENU_IDX+1)) ; else MENU_IDX=$MENU_MIN ; fi
		menu_redraw
	;;
	${KEY_HOME}) # home key, network recovery
		usbnet
		menu_init	
		menu_redraw
	;;
#	?*)
#		menu_debug "key $key"
#	;;
esac
done
}

if [ x"$PRODUCT" != "xRX-51" ]; then

#handle ask:xxx syntax
case "$default_root" in
	ask)
		show_bootmenu=yes
	;;
	ask:*)
		default_root=$(expr substr $default_root 5 100)
		show_bootmenu=yes
	;;
esac
else
	show_bootmenu=yes
fi

#try to preselect item with same id as preset in default_root
i=$MENU_MIN
while [ $i -le $MENU_MAX ] ; do
	eval label_id=\$MENU_${i}_ID
	[ "$label_id" = "$default_root" ] && MENU_IDX=$i
	i=$((i+1))
done

if [ "$HWKEYSTATE" = "$KEY_MENU" ] ; then
	show_bootmenu=yes
	MENU_TIMEOUT=-1 # menu requested by user, no timeout needed
fi

#show onscreeen menu
if [ "$show_bootmenu" = "yes" ] ; then
	menu_init
	menu_redraw
	menu_loop
fi

eval i=\$MENU_${MENU_IDX}_DEVICE ; [ -z "$i" ] || root_dev=$i
eval i=\$MENU_${MENU_IDX}_FSTYPE ; [ -z "$i" ] || root_fstype=$i
eval i=\$MENU_${MENU_IDX}_FSOPTIONS ; [ -z "$i" ] || root_fsoptions=$i
eval i=\$MENU_${MENU_IDX}_ID ; [ -z "$i" ] || default_root=$i

#handle special IDs (poweroff)
case "$default_root" in
        off)
		${T2S} -c
		poweroff
	;;
	flash)
		if [ x$PRODUCT = xRX-51 ]; then
			root_mounted=1
		fi
	;;
	*)
		root_mounted=0
	;;
esac

boot_message
eval i=\$MENU_${MENU_IDX}_FBMODE ; [ -z "$i" ] || /usr/bin/fb_update_mode $i
eval i=\$MENU_${MENU_IDX}_MODULES ; [ -z "$i" ] || load_modules $i
eval i=\$MENU_${MENU_IDX}_USBMODE ; [ -z "$i" ] || set_usb_mode $i
eval i=\$MENU_${MENU_IDX}_LINUXRC ; [ -z "$i" ] || transfer_to_linuxrc $root_dev $i
