#!/bin/sh

if test "$1" = "n900"; then

	echo "Creating debian configure scripts for build target Nokia N900..."
	test -f debian/rules && fakeroot debian/rules clean 1>/dev/null 2>&1
	rm -f debian/bootmenu-n900.tarlist debian/bootmenu.tarlist
	cp debian/bootmenu.dirs.n900 debian/bootmenu.dirs
	cp debian/bootmenu.install.n900 debian/bootmenu.install
	rm -f debian/bootmenu.links
	rm -f debian/bootmenu.postinst
	cp debian/control.n900 debian/control
	cp debian/rules.n900 debian/rules

elif test "$1" = "n8x0"; then

	echo "Creating debian configure scripts for build target Nokia N8x0..."
	test -f debian/rules && fakeroot debian/rules clean 1>/dev/null 2>&1
	rm -f debian/bootmenu-n900.tarlist debian/bootmenu.tarlist
	cp debian/bootmenu.dirs.n8x0 debian/bootmenu.dirs
	cp debian/bootmenu.install.n8x0 debian/bootmenu.install
	cp debian/bootmenu.links.n8x0 debian/bootmenu.links
	cp debian/bootmenu.postinst.n8x0 debian/bootmenu.postinst
	cp debian/control.n8x0 debian/control
	cp debian/rules.n8x0 debian/rules

elif test "$1" = "clean"; then

	echo "Removing debian configure scripts..."
	test -f debian/rules && fakeroot debian/rules clean 1>/dev/null 2>&1
	rm -f debian/bootmenu-n900.tarlist debian/bootmenu.tarlist
	rm -f debian/bootmenu.dirs
	rm -f debian/bootmenu.install
	rm -f debian/bootmenu.links
	rm -f debian/bootmenu.postinst
	rm -f debian/control
	rm -f debian/rules

else

	echo "Unknow option $1"
	echo "Usage:"
	echo "$0 n900"
	echo "$0 n8x0"
	echo "$0 clean"
	exit 1

fi
