#!/bin/sh
# cd /usr/lib/hildon-desktop
# python2.5 bluezwitch.py

import gobject
import gtk
import hildondesktop
import hildon
import os
import cairo
import osso
#import string
#import time 

import dbus

HOME = os.getenv('HOME')
APP_VERSION = "0.1"

class BluezwitchHomePlugin(hildondesktop.HomePluginItem):

  def __init__(self):
    hildondesktop.HomePluginItem.__init__(self)
    self.isStopped = True 
    self.update_info()
    self.transparency = 0.0

    self.bus = dbus.SystemBus();

    self.root = self.bus.get_object('org.bluez', '/')
    self.manager = dbus.Interface(self.root, 'org.bluez.Manager')
    self.defaultAdapter = self.manager.DefaultAdapter()
    print "Default adapter is at", self.defaultAdapter

    self.obj = self.bus.get_object('org.bluez', self.defaultAdapter)
    self.adapter = dbus.Interface(self.obj, 'org.bluez.Adapter')
    

  def update_info(self, widget=None):

    self.osso_context = osso.Context("com.tomch.bluezwitch", str(APP_VERSION), False)
    self.osso_rpc = osso.Rpc(self.osso_context)
   
    self.hbox = gtk.HBox()
    self.vbox = gtk.VBox()
    self.e_eventbox = gtk.EventBox()
    self.e_eventbox.set_size_request(48, 64) 
    self.e_eventbox.set_events(gtk.gdk.BUTTON_PRESS_MASK)
    self.e_eventbox.connect("button-release-event", self.on_toggle)
    self.hbox.pack_start(self.e_eventbox, True, True, 10)
    self.hbox.show_all()
    self.add(self.hbox)
    
  def do_expose_event(self, event):
    cr = self.window.cairo_create()
    cr.set_source_rgba(1.0, 1.0, 1.0, self.transparency) # Transparent
    cr.set_operator(cairo.OPERATOR_SOURCE)
    cr.paint()   

    # Paint icon for eventbox
    self.draw_e()

    # draw rounded rect
    width, height = self.allocation[2], self.allocation[3]
    
    x0 = 0
    y0 = 0
    radius = min(15, width/2, height/2)  #/*< and an approximate curvature radius */
    x1 = x0 + width
    y1 = y0 + height
    
    cr.move_to  (x0, y0 + radius)
    cr.arc (x0 + radius, y0 + radius, radius, 3.14, 1.5 * 3.14)
    cr.line_to (x1 - radius, y0)
    cr.arc (x1 - radius, y0 + radius, radius, 1.5 * 3.14, 0.0)
    cr.line_to (x1 , y1 - radius)
    cr.arc (x1 - radius, y1 - radius, radius, 0.0, 0.5 * 3.14)
    cr.line_to (x0 + radius, y1)
    cr.arc (x0 + radius, y1 - radius, radius, 0.5 * 3.14, 3.14)
    cr.close_path ()

    cr.set_source_rgba (0.0, 0.0, 0.0, self.transparency)
    cr.fill_preserve ()
    return False

  def draw_e(self):
    cr_e = self.e_eventbox.window.cairo_create()
    cr_e.set_source_rgba(0.0, 0.0, 0.0, self.transparency) # Transparent
    cr_e.set_operator(cairo.OPERATOR_SOURCE)
    cr_e.paint()
    
    cr_e.set_operator(cairo.OPERATOR_OVER)
    image = cairo.ImageSurface.create_from_png("/opt/tomch.com/bluezwitch/bluezwitch.png")
    cr_e.set_source_surface(image, 0, 7)
    cr_e.paint()
    self.cr_e = cr_e

  def do_realize(self):
    screen = self.get_screen()
    colormap = screen.get_rgba_colormap()
    self.set_colormap(colormap)
    hildondesktop.HomePluginItem.do_realize(self) 

  def on_toggle(self, button, data=None):
  
    props = self.adapter.GetProperties()
    powered = props['Powered']
    if powered:
      self.adapter.SetProperty('Powered',False) 
      banner = hildon.hildon_banner_show_information(self, "", "Bluetooth set off")
    else:
      self.adapter.SetProperty('Powered',True)   

hd_plugin_type = BluezwitchHomePlugin

if __name__ == "__main__":
    gobject.type_register(hd_plugin_type)
    obj = gobject.new(hd_plugin_type, plugin_id="plugin_id")
    obj.show_all()
    gtk.main()
