#
#      bluemaemo_bluez_conf.py
#
#      Copyright 2009 	Valerio Valerio <vdv100@gmail.com>
#						
#
#      This program is free software; you can redistribute it and/or modify
#      it under the terms of the GNU General Public License as published by
#      the Free Software Foundation; either version 2 of the License, or
#      (at your option) any later version.
#
#      This program is distributed in the hope that it will be useful,
#      but WITHOUT ANY WARRANTY; without even the implied warranty of
#      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#      GNU General Public License for more details.
#
#      You should have received a copy of the GNU General Public License
#      along with this program; if not, write to the Free Software
#      Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
#

from configobj import ConfigObj
import os

file = "/etc/bluetooth/main.conf"

class Bluez_conf:

	def __init__(self):
		self.restart_bluez = True
		self.commented_option = False
		self.options = ''
		self.new_options = 'input'
		self.config = ConfigObj(file)
		self.config_default = ConfigObj(file, list_values = False, stringify = False)

	def check_conf(self):
		try:
			self.options = self.config["General"]["DisablePlugins"]
			for i in self.options:
				if i == "input":
					self.restart_bluez = False
					print "Info: Input plugin disabled"
					break
		
			if self.restart_bluez:
				self.config["General"]["DisablePlugins"] = 'input'
				self.config.write()
				
		except:

			self.config["General"]["DisablePlugins"] = 'input'
			self.config.write()

	def restore_options(self):
		
		self.config_default.write()


