#!/usr/bin/python
# -*- coding: utf-8 -*-

import gtk
import hildon
from hildondesktop import StatusMenuItem
from os import system

class blankScreen(StatusMenuItem):
    def __init__(self):
        StatusMenuItem.__init__(self)

        self.button=hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL)
        self.button.set_style(hildon.BUTTON_STYLE_PICKER)
        self.button.set_alignment(0.2,0.5,1,1)
        self.image=gtk.image_new_from_file("/usr/share/icons/hicolor/48x48/hildon/blank-screen.png")
        self.button.set_image_position(gtk.POS_LEFT)
        self.button.set_image(self.image)
        
        hbox=gtk.HBox(False, 0)
        hbox.pack_start(self.button, True, True, 0)

        self.add(hbox)
        self.show_all()


        self.button.connect("clicked", self.buttonClicked)
        self.button.tap_and_hold_setup(None, None, 0)
        self.button.connect("tap-and-hold", self.buttonPressed)

    def buttonClicked(self, dummy):
        self.get_toplevel().hide()
        system("blank-screen")

    def buttonPressed(self, dummy):
        system("dbus-send --system --type=method_call --dest=com.nokia.mce /com/nokia/mce/request com.nokia.mce.request.req_tklock_mode_change string:'locked'")
        
hd_plugin_type = blankScreen
