#! /bin/sh -e

THEMEDIR='/usr/share/themes/blackplastictheme-themedir'

if [ ! -d $THEMEDIR ]; then
  exit 0
fi

rm -rf /usr/share/themes/blackplastictheme-themedir/gtk-2.0/*.cache

if [ "`readlink /etc/hildon/theme`" = /usr/share/themes/blackplastictheme-themedir ]; then
   if [ -x /usr/bin/personalisation ]; then
	   /usr/bin/personalisation /usr/share/themes/default
   fi
fi

# Q=`run-standalone.sh zenity --question --text="Enable customized transitions?\n(affects only the Black Plastic theme)\n\nNote: tap outside this window to NOT to enable the transitions\n\n(choose Yes if you don't know what to do)" --ok-label=Yes; echo $?`

Q=`run-standalone.sh zenity  --list  --text "Enable or disable custom transitions" --radiolist  --column "Pick" --column "Transition" TRUE "Enable custom transitions" FALSE "Disable custom transitions"; echo $ans`

if [ "$Q" = "Enable custom transitions" ]; then
      # install the custom things
     	cp -rf /usr/share/themes/blackplastictheme-themedir/transitions.tmp /usr/share/themes/blackplastictheme-themedir/transitions.ini

else

	rm -rf /usr/share/themes/blackplastictheme-themedir/transitions.ini

fi

Q2=`run-standalone.sh zenity  --list  --text "Choose color scheme" --radiolist  --column "Pick" --column "Scheme" TRUE Black FALSE Blue FALSE Orange FALSE Pink; echo $ans`

if [ "$Q2" = "Black" ]; then

	cp -rf /usr/share/themes/blackplastictheme-themedir/variations/black/* /usr/share/themes/blackplastictheme-themedir/

elif [ "$Q2" = "Blue" ]; then

	cp -rf /usr/share/themes/blackplastictheme-themedir/variations/blue/* /usr/share/themes/blackplastictheme-themedir/

elif [ "$Q2" = "Orange" ]; then

	cp -rf /usr/share/themes/blackplastictheme-themedir/variations/orange/* /usr/share/themes/blackplastictheme-themedir/

elif [ "$Q2" = "Pink" ]; then

	cp -rf /usr/share/themes/blackplastictheme-themedir/variations/pink/* /usr/share/themes/blackplastictheme-themedir/

fi

hildon-theme-cacher $THEMEDIR
Q3=`run-standalone.sh zenity --info --text="Done! Now go and select Black Plastic Theme to use and then reboot the phone to make all changes visible."`

exit 0
