/*
 *  Copyright 2010 Ruediger Gad
 *
 *  This file is part of Binary Clock.
 *
 *  Binary Clock is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Binary Clock is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Binary Clock.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <QDateTime>

#include "unixtimewidget.h"

UnixTimeWidget::UnixTimeWidget(QWidget *parent) :
        ClockWidget(parent)
{
    layout = new QVBoxLayout(this);

    fourthByte = new HorizontalBinaryDisplayWidget(8, 0);
    connect(this, SIGNAL(settingsChanged()), fourthByte, SLOT(applySettings()));
    layout->addWidget(fourthByte);

    thirdByte = new HorizontalBinaryDisplayWidget(8, 1);
    connect(this, SIGNAL(settingsChanged()), thirdByte, SLOT(applySettings()));
    layout->addWidget(thirdByte);

    secondByte = new HorizontalBinaryDisplayWidget(8, 1);
    connect(this, SIGNAL(settingsChanged()), secondByte, SLOT(applySettings()));
    layout->addWidget(secondByte);

    if(showSeconds){
        firstByte = new HorizontalBinaryDisplayWidget(8, 1);
        connect(this, SIGNAL(settingsChanged()), firstByte, SLOT(applySettings()));
        layout->addWidget(firstByte);
    }else{
        firstByte = NULL;
    }

    setFixedSize(sizeHint());
    layout->setSizeConstraint(QLayout::SetMinimumSize);

    updateTime();
}

UnixTimeWidget::~UnixTimeWidget(){
    if(firstByte != NULL){
        delete firstByte;
    }
    delete secondByte;
    delete thirdByte;
    delete fourthByte;

    delete layout;
}

QSize UnixTimeWidget::sizeHint(){
    return QSize((8 * (fourthByte->getElementSize())) + (2 * layout->margin())
#ifdef Q_WS_MAEMO_5
                 + 35
#endif
                 ,
                 (((showSeconds) ? 4 : 3) * fourthByte->getElementSize()) + (((showSeconds) ? 3 : 2) * layout->margin()) + 6);
}

void UnixTimeWidget::updateTime(){
    uint time = QDateTime::currentDateTime().toUTC().toTime_t();

    if(firstByte != NULL){
        firstByte->updateValue(time & 0xFF);
    }
    secondByte->updateValue((time >> 8) & 0xFF);
    thirdByte->updateValue((time >> 16) & 0xFF);
    fourthByte->updateValue((time >> 24) & 0xFF);
}
