/*
 *  Copyright 2010 Ruediger Gad
 *
 *  This file is part of Binary Clock.
 *
 *  Binary Clock is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Binary Clock is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Binary Clock.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <QSettings>
#include <QTime>

#include "binaryclockwidget.h"
#include "settingsdialog.h"

BinaryClockWidget::BinaryClockWidget(QWidget *parent) :
    ClockWidget(parent)
{
    layout = new QVBoxLayout(this);

    hoursWidget = new HorizontalBinaryDisplayWidget(5, 3, 6);
    connect(this, SIGNAL(settingsChanged()), hoursWidget, SLOT(applySettings()));
    layout->addWidget(hoursWidget);

    minutesWidget = new HorizontalBinaryDisplayWidget(6, 2);
    connect(this, SIGNAL(settingsChanged()), minutesWidget, SLOT(applySettings()));
    layout->addWidget(minutesWidget);

    if(showSeconds){
        secondsWidget = new HorizontalBinaryDisplayWidget(6, 1);
        connect(this, SIGNAL(settingsChanged()), secondsWidget, SLOT(applySettings()));
        layout->addWidget(secondsWidget);
    }else{
        secondsWidget = NULL;
    }

    setFixedSize(sizeHint());
    layout->setSizeConstraint(QLayout::SetMinimumSize);

    updateTime();
}

BinaryClockWidget::~BinaryClockWidget(){
    if(secondsWidget != NULL){
        delete secondsWidget;
    }
    delete minutesWidget;
    delete hoursWidget;

    delete layout;
}

QSize BinaryClockWidget::sizeHint(){
    return QSize((6 * (hoursWidget->getElementSize())) + (2 * layout->margin())
#ifdef Q_WS_MAEMO_5
                 + 35
#endif
                 ,
                 (((showSeconds) ? 3 : 2) * hoursWidget->getElementSize()) + (2 * layout->margin()) + 6);
}

void BinaryClockWidget::updateTime(){
    QTime time = QTime::currentTime();

    if(secondsWidget != NULL){
        secondsWidget->updateValue(time.second());
    }
    minutesWidget->updateValue(time.minute());
    hoursWidget->updateValue(time.hour());
}
