/*
 *  Copyright 2010 Ruediger Gad
 *
 *  This file is part of Binary Clock.
 *
 *  Binary Clock is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Binary Clock is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Binary Clock.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <QTime>

#include "bcdclockwidget.h"

BcdClockWidget::BcdClockWidget(QWidget *parent) :
    ClockWidget(parent)
{
    layout = new QHBoxLayout(this);

    secondsOneWidget = new VerticalBinaryDisplayWidget(4, 1);
    secondsTenWidget = new VerticalBinaryDisplayWidget(3, 2, 4);
    minutesOneWidget = new VerticalBinaryDisplayWidget(4, 3);
    minutesTenWidget = new VerticalBinaryDisplayWidget(3, 4, 4);
    hoursOneWidget = new VerticalBinaryDisplayWidget(4, 1);
    hoursTenWidget = new VerticalBinaryDisplayWidget(2, 2, 4);

    layout->addWidget(hoursTenWidget);
    layout->addWidget(hoursOneWidget);
    layout->addWidget(minutesTenWidget);
    layout->addWidget(minutesOneWidget);
    layout->addWidget(secondsTenWidget);
    layout->addWidget(secondsOneWidget);

    setFixedSize(sizeHint());
    layout->setSizeConstraint(QLayout::SetMinimumSize);

    updateTime();
}

BcdClockWidget::~BcdClockWidget(){
    delete secondsOneWidget;
    delete secondsTenWidget;
    delete minutesOneWidget;
    delete minutesTenWidget;
    delete hoursOneWidget;
    delete hoursTenWidget;

    delete layout;
}

void BcdClockWidget::setLedSize(int size){
    secondsOneWidget->setLedSize(size);
    secondsTenWidget->setLedSize(size);
    minutesOneWidget->setLedSize(size);
    minutesTenWidget->setLedSize(size);
    hoursOneWidget->setLedSize(size);
    hoursTenWidget->setLedSize(size);
}

void BcdClockWidget::setLedBorder(int border){
    secondsOneWidget->setLedBorder(border);
    secondsTenWidget->setLedBorder(border);
    minutesOneWidget->setLedBorder(border);
    minutesTenWidget->setLedBorder(border);
    hoursOneWidget->setLedBorder(border);
    hoursTenWidget->setLedBorder(border);
}

void BcdClockWidget::setLedColor(const QColor &color){
    secondsOneWidget->setLedColor(color);
    secondsTenWidget->setLedColor(color);
    minutesOneWidget->setLedColor(color);
    minutesTenWidget->setLedColor(color);
    hoursOneWidget->setLedColor(color);
    hoursTenWidget->setLedColor(color);
}

QSize BcdClockWidget::sizeHint(){
    return QSize((6 * secondsOneWidget->getElementSize()) + (2 * layout->margin()) + 35,
                 (4 * secondsOneWidget->getElementSize()) + (2 * layout->margin())
#ifdef Q_WS_MAEMO_5
                 + 6
#endif
                 );
}

void BcdClockWidget::updateTime(){
    QTime time = QTime::currentTime();

    secondsOneWidget->updateValue(time.second() % 10);
    secondsTenWidget->updateValue(time.second() / 10);
    minutesOneWidget->updateValue(time.minute() % 10);
    minutesTenWidget->updateValue(time.minute() / 10);
    hoursOneWidget->updateValue(time.hour() % 10);
    hoursTenWidget->updateValue(time.hour() / 10);
}
