/*
 *  Copyright 2010 Ruediger Gad
 *
 *  This file is part of Binary Clock.
 *
 *  Binary Clock is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Binary Clock is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Binary Clock.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef SETTINGSDIALOG_H
#define SETTINGSDIALOG_H

#include <QDialog>

namespace Ui {
    class SettingsDialog;
}

class SettingsDialog : public QDialog
{
    Q_OBJECT

public:
    static const QString CLOCK_LED_COLOR;
    static const QColor CLOCK_LED_COLOR_DEFAULT;

    static const QString CLOCK_STYLE;
    static const int CLOCK_STYLE_DEFAULT;

    static const QString LED_BORDER;
    static const int LED_BORDER_DEFAULT;

    static const QString LED_SIZE;
    static const int LED_SIZE_DEFAULT;

#ifndef Q_WS_MAEMO_5
    static const QString POSITION;
    static const QPoint POSITION_DEFAULT;

    static const QString TRANSPARENCY;
    static const bool TRANSPARENCY_DEFAULT;

    static const QString WIDGET_PLACEMENT;
    static const int WIDGET_PLACEMENT_DEFAULT;
#endif


    explicit SettingsDialog(QWidget *parent = 0);
    ~SettingsDialog();

    void accept();

private:
    Ui::SettingsDialog *ui;
};

#endif // SETTINGSDIALOG_H
