/*
 *  Copyright 2010 Ruediger Gad
 *
 *  This file is part of Binary Clock.
 *
 *  Binary Clock is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Binary Clock is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Binary Clock.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef MAINWIDGET_H
#define MAINWIDGET_H

#ifndef Q_WS_MAEMO_5
#include <QAction>
#include <QMenu>
#include <QMouseEvent>
#endif

#include <QPaintEvent>
#include <QVBoxLayout>
#include <QWidget>

#include "bcdclockwidget.h"
#include "binaryclockwidget.h"

class MainWidget : public QWidget
{
    Q_OBJECT
public:
    explicit MainWidget(QWidget *parent = 0);
    ~MainWidget();

public slots:
    void openSettingsDialog();

protected:
    void paintEvent(QPaintEvent *event);

private slots:
    void setClock(int clockStyle);

private:
    ClockWidget *clockWidget;

    QVBoxLayout *layout;

    void applySettings();

#ifndef Q_WS_MAEMO_5
protected:
    void mouseMoveEvent(QMouseEvent *);
    void mousePressEvent(QMouseEvent *event);

private:
    QPoint position;

    QMenu *menu;
    QAction *closeAction;
    QAction *settingsAction;

    bool transparency;

    void createMenu();
#endif
};

#endif // MAINWIDGET_H
