/*
 *  Copyright 2010 Ruediger Gad
 *
 *  This file is part of Binary Clock.
 *
 *  Binary Clock is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Binary Clock is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Binary Clock.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <QSettings>
#include <QStringList>

#include "settingsdialog.h"
#include "ui_settingsdialog.h"

const QString SettingsDialog::CLOCK_LED_COLOR = "clock_led_color";
const QString SettingsDialog::CLOCK_STYLE = "clock_style";

const QColor SettingsDialog::CLOCK_LED_COLOR_DEFAULT = QColor(Qt::red);
const int SettingsDialog::CLOCK_STYLE_DEFAULT = 0;

SettingsDialog::SettingsDialog(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::SettingsDialog)
{
    ui->setupUi(this);

    QStringList styles;
    styles.append("Binary Clock");
    styles.append("BCD Clock");

    QSettings settings;
    ui->clockStyleComboBox->addItems(styles);
    ui->clockStyleComboBox->setCurrentIndex(settings.value(SettingsDialog::CLOCK_STYLE,
                                                           SettingsDialog::CLOCK_STYLE_DEFAULT).toInt());
    ui->ledColorSelectionButton->setColor(settings.value(SettingsDialog::CLOCK_LED_COLOR,
                                          SettingsDialog::CLOCK_LED_COLOR_DEFAULT).value<QColor>());
}

SettingsDialog::~SettingsDialog()
{
    delete ui;
}

void SettingsDialog::accept(){
    QSettings settings;

    settings.setValue(SettingsDialog::CLOCK_LED_COLOR, ui->ledColorSelectionButton->getColor());
    settings.setValue(SettingsDialog::CLOCK_STYLE, ui->clockStyleComboBox->currentIndex());

    settings.sync();

    done(1);
}
