/*
 *  Copyright 2010 Ruediger Gad
 *
 *  This file is part of Binary Clock.
 *
 *  Binary Clock is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Binary Clock is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Binary Clock.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <QTime>

#include "binaryclockwidget.h"

BinaryClockWidget::BinaryClockWidget(QWidget *parent) :
    ClockWidget(parent)
{
    layout = new QVBoxLayout(this);

    secondsWidget = new HorizontalBinaryDisplayWidget(6, 1);
    minutesWidget = new HorizontalBinaryDisplayWidget(6, 2);
    hoursWidget = new HorizontalBinaryDisplayWidget(5, 3, 6);

    layout->addWidget(hoursWidget);
    layout->addWidget(minutesWidget);
    layout->addWidget(secondsWidget);

    setFixedSize(sizeHint());

    updateTime();

    timer = new QTimer();
    timer->setInterval(1000);
    connect(timer, SIGNAL(timeout()), this, SLOT(updateTime()));
    timer->start();
}

BinaryClockWidget::~BinaryClockWidget(){
    timer->stop();
    delete timer;

    delete secondsWidget;
    delete minutesWidget;
    delete hoursWidget;

    delete layout;
}

void BinaryClockWidget::setBaseSize(int size){
    secondsWidget->setBaseSize(size);
    minutesWidget->setBaseSize(size);
    hoursWidget->setBaseSize(size);
}

void BinaryClockWidget::setBorder(int border){
    secondsWidget->setBorder(border);
    minutesWidget->setBorder(border);
    hoursWidget->setBorder(border);
}

void BinaryClockWidget::setLedColor(const QColor &color){
    secondsWidget->setLedColor(color);
    minutesWidget->setLedColor(color);
    hoursWidget->setLedColor(color);
}

QSize BinaryClockWidget::sizeHint(){
    return QSize((6 * (secondsWidget->getBaseSize())) + (2 * layout->margin()) + 35,
                 (3 * secondsWidget->getBaseSize()) + (2 * layout->margin()) + 6);
}

void BinaryClockWidget::updateTime(){
    QTime time = QTime::currentTime();

    secondsWidget->updateValue(time.second());
    minutesWidget->updateValue(time.minute());
    hoursWidget->updateValue(time.hour());
}
