#ifndef MAPWIDGET_H
#define MAPWIDGET_H

#include <QtNetwork/QNetworkAccessManager>
#include <QtNetwork/QNetworkReply>
#include <QtGui>

#include "gpsposition.h"

#include <QGeoCoordinate>

QTM_USE_NAMESPACE

class MapWidget : public QWidget
{
    Q_OBJECT

public:
    MapWidget(const QGeoCoordinate&, const QGeoCoordinate&, QWidget* parent = 0);
    void paintEvent(QPaintEvent* paintEvent);

public slots:
    void handleNetworkData(QNetworkReply* reply);

private:
    void fetchMap(const QSize&, const QGeoCoordinate&, const QGeoCoordinate&);

    QNetworkAccessManager networkAccessManager;
    QPixmap mapPixmap;
};

#endif // MAPWIDGET_H
