#include "gpsposition.h"

GPSPosition::GPSPosition(QObject *parent) :
    QObject(parent) {
    tolerance = 50;
    location = QGeoPositionInfoSource::createDefaultSource(this);
    connect(location, SIGNAL(positionUpdated(QGeoPositionInfo)), this, SLOT(onPositionUpdated(QGeoPositionInfo)));
    location->startUpdates();
    location->setUpdateInterval(30000);
    location->requestUpdate();
}

qreal GPSPosition::getLatitude() const {
    return coordinate.latitude();
}

qreal GPSPosition::getLongitude() const {
    return coordinate.longitude();
}

void GPSPosition::setTolerance(qreal newTolerance) {
    tolerance = newTolerance;
}

QGeoCoordinate GPSPosition::getCoordinate() const {
    return coordinate;
}

void GPSPosition::onPositionUpdated(QGeoPositionInfo position) {
    coordinate = position.coordinate();
    if (coordinate.distanceTo(lastEmitted) > tolerance) {
        lastEmitted = coordinate;
        emit movedTolerance();
    }
    qDebug() << "Position updated : " << coordinate;
}

GPSPosition& GPSPosition::getInstance() {
    static GPSPosition instance;
    return instance;
}

void GPSPosition::requestUpdate() {
    location->requestUpdate();
}
