/*
 * Station.cpp
 *
 *  Created on: Nov 3, 2010
 *      Author: Thomas Schwery
 */

#include "Station.h"

Station::Station(QString name, QString network, float gpsX, float gpsY, int freeBikes, int freeStations)
    : QObject() {
    this->name = name;
    this->network = network;
    this->xPosition = gpsX;
    this->yPosition = gpsY;
    this->freeBikes = freeBikes;
    this->freeStations = freeStations;
}

Station::~Station() {
    // TODO Auto-generated destructor stub
}

QPushButton * Station::getButton() {
    QPushButton *cb = new QPushButton(QString(""));

    QString infoBikes = tr("Bikes: %1").arg(freeBikes);

    QString infoStations = tr("Stations: %1").arg(freeStations);

    QLabel * labelBikes = new QLabel(infoBikes);
    QLabel * labelStations = new QLabel(infoStations);

    labelBikes->setAlignment(Qt::AlignRight);
    labelStations->setAlignment(Qt::AlignRight);

    QLabel * labelNetwork = new QLabel(network);
    QLabel * labelName = new QLabel(name);

    QHBoxLayout * layout = new QHBoxLayout(cb);

    QVBoxLayout * stationLayout = new QVBoxLayout();
    QVBoxLayout * infoLayout = new QVBoxLayout();

    stationLayout->addWidget(labelName);
    stationLayout->addWidget(labelNetwork);

    infoLayout->setAlignment(Qt::AlignRight);
    infoLayout->addWidget(labelBikes);
    infoLayout->addWidget(labelStations);

    layout->addLayout(stationLayout);
    layout->addLayout(infoLayout);

    cb->setLayout(layout);

#ifndef Q_WS_MAEMO_5
    cb->adjustSize();
#endif

    return cb;
}

qreal Station::getLatitude() const {
    return qreal(xPosition);
}

qreal Station::getLongitude() const {
    return qreal(yPosition);
}

QGeoCoordinate Station::getCoordinate() const {
    return QGeoCoordinate(xPosition, yPosition);
}

QLayout * Station::getLayout() {
    QVBoxLayout * vbox = new QVBoxLayout();

    QHBoxLayout * line1 = new QHBoxLayout();

    QString stringName = QString("%1 (%2)").arg(name, network);
    QLabel * labelName = new QLabel(stringName);

    QString stringDistance = getDistanceToUser();
    QLabel * labelDistance = new QLabel(stringDistance);

    line1->addWidget(labelName);
    line1->addStretch();
    line1->addWidget(labelDistance);

    QHBoxLayout * line2 = new QHBoxLayout();

    QString stringBikes = tr("Free bikes: %1").arg(freeBikes);
    QLabel * labelBikes = new QLabel(stringBikes);

    QString stringStations = tr("Free stations: %1").arg(freeStations);
    QLabel * labelStations = new QLabel(stringStations);

    line2->addWidget(labelBikes);
    line2->addStretch();
    line2->addWidget(labelStations);

    vbox->addLayout(line1);
    vbox->addLayout(line2);

    return vbox;
}

QString Station::getName() const {
    return name;
}

QString Station::getNetwork() const {
    return network;
}

int Station::getFreeBikes() const {
    return freeBikes;
}

int Station::getFreeStations() const {
    return freeStations;
}

QString Station::getDistanceToUser() const {
    QGeoCoordinate stationCoordinates(getLatitude(), getLongitude());
    QGeoCoordinate userCoordinates(GPSPosition::getInstance().getCoordinate());
    qreal distance = stationCoordinates.distanceTo(userCoordinates);

    QString labelDistance = "";
    if (distance < 1000) {
        labelDistance += tr("%1 meters").arg(distance);
    } else {
        distance /= 1000;
        labelDistance += tr("%1 km").arg(distance);
    }

    return labelDistance;
}

QTextStream &operator<<(QTextStream &out, const Station &station) {
    out << station.getName() << "(" << station.getNetwork() << ") - Bikes:" << station.getFreeBikes() << ", Stations:" << station.getFreeStations();
    return out;
}
