/*
 * PageParser.cpp
 *
 *  Created on: Nov 3, 2010
 *      Author: Thomas Schwery
 */

#include "PageParser.h"
#include <QTextStream>
#include <QFile>
#include <QUrl>

PageParser::PageParser() {
    // TODO Auto-generated constructor stub

}

PageParser::~PageParser() {
    // TODO Auto-generated destructor stub
}


QMap<QString, Station*>* PageParser::parsePage(QString data) {
    QMap<QString, Station*> * stations = new QMap<QString, Station*>();

    QStringList dataLines = data.split('\n').mid(20, 10);

    QString split_line = dataLines.filter(QRegExp("var d1 =", Qt::CaseSensitive, QRegExp::FixedString)).at(0);
    QChar split_char('_');
    QRegExp regexSeparator("=.'(.)'");
    if (regexSeparator.indexIn(split_line) > -1) {
        split_char = regexSeparator.cap(1).at(0);
    }

    QStringList dataLines2 = dataLines.filter(QRegExp("var sita_", Qt::CaseInsensitive, QRegExp::FixedString));

    dataLines2.replaceInStrings(QRegExp("\"\\+.*"), "");
    dataLines2.replaceInStrings(QRegExp("^.*= \""), "");
    dataLines2.replaceInStrings("\";", "");

    QStringList name = dataLines2.at(2).split(split_char);
    QStringList status = dataLines2.at(4).split(split_char);
    QStringList network = dataLines2.at(6).split(split_char);
    QStringList xList = dataLines2.at(0).split(split_char);
    QStringList yList = dataLines2.at(1).split(split_char);

    name.replaceInStrings(QRegExp("^ +"), "");
    name.replaceInStrings("&#233;","e");
    name.replaceInStrings("&#232;","e");

    for (int i =0; i<name.size(); ++i) {
        // Dropping the stations with invalid name
        if (name.at(i) == "") continue;

        float x = xList.at(i).toFloat();
        float y = yList.at(i).toFloat();
        Station * newStation = new Station(name.at(i), network.at(i), x, y, status.at(i).count('4'), status.at(i).count('0'));
        stations->insert(name.at(i), newStation);
    }

    return stations;
}
