/*
 * RequestSummary.h
 *
 *  Created on: Nov 2, 2010
 *      Author: Thomas Schwery
 */

#ifndef REQUESTSUMMARY_H_
#define REQUESTSUMMARY_H_

#include "StationsState.h"
#include "Station.h"

#include <QWidget>
#include <QtGui>
#include <QWidget>
#include <QPushButton>
#include <QMainWindow>
#include <QWidgetAction>
#include <QtConcurrentRun>

class MainWindow : public QMainWindow
{
    Q_OBJECT;
public:
    MainWindow(StationsState * state, QWidget *parent = 0);
    virtual ~MainWindow();

public slots:
    void popupStation(QString);
    void dataUpdated();
    void update();

signals:
    void updateData();

private:
    StationsState * state;
    QVBoxLayout * mainLayout;
    QSignalMapper * signalMapper;
    QSignalMapper * signalMapperMenu;
    QProgressDialog * pd;

    void clearLayout();
};

#endif /* REQUESTSUMMARY_H_ */
