CONFIG += qt
CONFIG += silent
CONFIG += mobility

QT += network

MOBILITY = location

TARGET = BiciMobile

QMAKE_CXXFLAGS+=-O3 -Wextra -fstack-protector -Wundef -Wpointer-arith
QMAKE_CXXFLAGS+=-Wconversion -Winit-self -Wuninitialized -Wstrict-null-sentinel

QMAKE_LFLAGS+=-as-needed

# keep the tree clean
DESTDIR = build
OBJECTS_DIR = build
MOC_DIR = src/.tmp
# In Eclipse, "clean" removes binaries too.  This is also needed to work around timestamp
# issues between host and VM in ESbox.
QMAKE_CLEAN += $$DESTDIR/BiciMaemo

HEADERS = src/MainWindow.h \
          src/PageDownloader.h \
          src/PageParser.h \
          src/Station.h \
          src/StationDetail.h \
          src/StationsState.h \
          src/UpdaterThread.h \
    src/mapwidget.h \
    src/gpsposition.h

SOURCES = src/MainWindow.cpp \
          src/PageDownloader.cpp \
          src/PageParser.cpp \
          src/Station.cpp \
          src/StationDetail.cpp \
          src/StationsState.cpp \
          src/UpdaterThread.cpp \
          src/main.cpp \
    src/mapwidget.cpp \
    src/gpsposition.cpp

# TEMPLATE = app
# DESTDIR = /path/to/installation
# DEFINES += MACRO_1 ... 

# CONFIG += link_pkgconfig
# PKGCONFIG += ogg dbus-1

# install
target.path = /usr/bin
INSTALLS += target

unix{
	#VARIABLES
	isEmpty(PREFIX) {
	PREFIX = /usr
	}
	BINDIR = $$PREFIX/bin
	DATADIR =$$PREFIX/share

	DEFINES += DATADIR=\\\"$$DATADIR\\\" PKGDATADIR=\\\"$$PKGDATADIR\\\"

	#MAKE INSTALL

	INSTALLS += target desktop icon48
	target.path = $$BINDIR

	desktop.path = $$DATADIR/applications/hildon
	desktop.files += data/bicimobile.desktop

	icon48.path = $$DATADIR/icons/hicolor/48x48/apps
	icon48.files += data/bicimobile.png
}
