/*
 * Station.h
 *
 *  Created on: Nov 3, 2010
 *      Author: Thomas Schwery
 */

#ifndef STATION_H_
#define STATION_H_

#include <QString>
#include <QTextStream>
#include <QtGui>

#include <QGeoCoordinate>
#include "gpsposition.h"

QTM_USE_NAMESPACE;

class Station {
public:
    Station(QString, QString, float, float, int, int);
    virtual ~Station();

    QPushButton * getButton();
    QLayout * getLayout();

    QString getName() const;
    QString getNetwork() const;
    int getFreeBikes() const;
    int getFreeStations() const;

    qreal getLatitude() const;
    qreal getLongitude() const;
    QGeoCoordinate getCoordinate() const;

private:
    QString name;
    QString network;
    float xPosition;
    float yPosition;
    int freeBikes;
    int freeStations;
};

QTextStream &operator<<(QTextStream &out, const Station &station);

#endif /* STATION_H_ */
