#include "gpsposition.h"

GPSPosition::GPSPosition(QObject *parent) :
    QObject(parent) {

    QGeoPositionInfoSource * location = QGeoPositionInfoSource::createDefaultSource(this);
    connect(location, SIGNAL(positionUpdated(QGeoPositionInfo)), this, SLOT(onPositionUpdated(QGeoPositionInfo)));
    location->startUpdates();
    location->setUpdateInterval(30000);
    location->requestUpdate();
}

qreal GPSPosition::getLatitude() const {
    return coordinate.latitude();
}

qreal GPSPosition::getLongitude() const {
    return coordinate.longitude();
}

QGeoCoordinate GPSPosition::getCoordinate() const {
    return coordinate;
}

void GPSPosition::onPositionUpdated(QGeoPositionInfo position) {
    coordinate = position.coordinate();
    qDebug() << "Position updated : " << coordinate << endl;
}

GPSPosition& GPSPosition::getInstance() {
    static GPSPosition instance;
    return instance;
}
