/*
 * UpdaterThread.h
 *
 *  Created on: Nov 3, 2010
 *      Author: Thomas Schwery
 */

#ifndef UPDATERTHREAD_H_
#define UPDATERTHREAD_H_

#include <QTimer>
#include <QTextStream>

class PageDownloader;

#include "Station.h"
#include "StationsState.h"
#include "PageDownloader.h"
#include "PageParser.h"

class UpdaterThread : public QObject {
    Q_OBJECT
public:
    UpdaterThread(StationsState * state);
    virtual ~UpdaterThread();

public slots:
    void update();
    void dataArrived();
    
signals:
    void dataUpdated();

private:
    StationsState * state;
    QTimer * updaterTimer;
    PageDownloader * pageDl;
};

#endif /* UPDATERTHREAD_H_ */
