#!/usr/bin/python
# -*- coding: utf-8 -*-
# Copyright (c) 2011 Marian Kluehspies <marian300@gmx.de>

# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:

# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.

# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
# THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
# DEALINGS IN THE SOFTWARE.
#########################################################################################################################
#BFBCS API:
#all - alias for: general,kits,teams,weapons,vehicles,gadgets,specializations,insiginias,pins,achievements
#general - some general data
#kits - data about kits
#teams - data about teams(attacker, defender)
#weapons
#vehicles
#gadgets
#specializations
#insiginias
#pins
#achievements
#dogtags
#grimg - get img key with path to image files
#basic - all other fields will be ignored, only basic info
#online - online status of player
#progress - get progress for rank, kits and stars
#misc - some other data not included in aboves data
#raw - all data in raw format



import urllib
#import sqlite3
try:
    import simplejson as json
except:
    import json
import sys
import bfsource
#import connect
import os
from PyQt4 import QtCore
from PyQt4.QtCore import Qt
from PyQt4 import QtGui
from PyQt4.uic import loadUi




class MainWindow(QtGui.QMainWindow):
    def __init__(self, parent=None):
        QtGui.QMainWindow.__init__(self,parent)
        try:    
            self.ui=loadUi("/opt/bfbc2stats/bfstats.ui")
            #print"Program running on Maemo"
        except:
            self.ui=loadUi("bfstats.ui")
            #print"Program running on PC" 
               
        self.ui.show()
        self.ui.setAttribute(Qt.WA_Maemo5PortraitOrientation, True)
        
        #print"Debugger: \n\n"
        self.ui.showFullScreen()
        self.ui.activate.hide()
        self.ui.showbutton.hide()
        self.ui.search.clicked.connect(self.get_list)
        self.ui.activate.toggled.connect(self.set_as_default)
        self.ui.exit.clicked.connect(self.closefunc)
        self.ui.hidebutton.clicked.connect(self.hideui)
        self.ui.showbutton.clicked.connect(self.releaseui)
        self.ui.banner.clicked.connect(self.information)
        self.ui.minimize.clicked.connect(self.minimizefunc)
        self.ui.statsshow.setReadOnly(True)
        #self.ui.playername.home(True)
        #self.ui.playername.returnPressed(self.get_list)
        #if os.path.isfile("defaultplayer.ini"):
            #print"defaultplayer.ini is in path"
            #pass
        #else:
            #print"Directory created"
        try:
            os.makedirs("/home/user/MyDocs/.bfbc2stats/")
        except:
            pass    
        
        #Üperprüfen, ob defaultplayer.txt vorhanden ist.Falls ja, Inhalt überprüfen.Wenn Inhalt leer, pass, wenn Inhalt vorhanden, laden
        if os.path.isfile("/home/user/MyDocs/.bfbc2stats/defaultplayer.ini"):
           
             
            if os.lstat("/home/user/MyDocs/.bfbc2stats/defaultplayer.ini").st_size > 0:
                userdata={}
                #try:
                fobj=open("/home/user/MyDocs/.bfbc2stats/defaultplayer.ini","r")
                #except:    
                    #fobj=open("defaultplayer.ini","r")
                for line in fobj:
                    zuordnung=line.split()
                    userdata[zuordnung[0]]=zuordnung[1]
                    fobj.close  
                
                setplayername=userdata["setplayername"]
                setplatform=userdata["setplatform"]
                index=userdata["index"]
                self.ui.playername.setText(setplayername)
                print"read from defaultplayer.ini"
                self.ui.statsshow.clear()
                self.ui.activate.setChecked(True)
                self.get_stats_general(userdata)
                try:
                    print"read from bfbc2statscache.ini"
                    #try:
                    fobj=open("/home/user/MyDocs/.bfbc2stats/bfbc2statscache.ini","r")
                    #except:    
                        #fobj=open("bfbc2statscache.ini","r")
                    cachetext=fobj.read()
                    self.ui.statsshow.setText(cachetext)
                    fobj.close()
                except:
                    print"except1"
                    pass    
                

                self.ui.platform.setCurrentIndex(int(index))
            
               
            else:
                pass
                self.ui.statsshow.setText("No userdata available!")  
                 
                 
    def hideui(self):
        #print"Fullscreen activated"
        self.ui.playername.hide()
        self.ui.platform.hide()
        self.ui.search.hide()
        self.ui.activate.hide()
        self.ui.hidebutton.hide()  
        self.ui.showbutton.show() 
     
    def releaseui(self):
        #print"Fullscreen deaktivated"
        self.ui.playername.show()
        self.ui.platform.show()  
        self.ui.showbutton.hide()
        self.ui.hidebutton.show() 
        self.ui.activate.show()
        self.ui.search.show()      

        
    def get_list(self):
        #import connect 
        index=self.ui.platform.currentIndex()
        #print index
        setplatform=self.ui.platform.currentText()
        setplayername=self.ui.playername.text() 
        if index!=int(3):
                #print"Index not 3,...."
                if setplatform=="Xbox 360":
                    setplatform=str(360)
                elif setplatform =="Playstation 3":
                    setplatform="ps3"
                elif setplatform =="PC":
                    setplatform="pc"
            
   ##############################################################################################                 
        
                if setplayername != "":
            
                    userdata={"setplayername" : setplayername, "setplatform" : setplatform}
                    self.get_stats_general(userdata)
                       
                else:
                    self.ui.statsshow.setText("Please enter a valid playername")
        else:
            self.get_stats_global() 
            #print"General choosen, jumping to get_stats_global()"           
            
    def get_stats_general(self,userdata):
        #self.ui.statsshow.setText("Fetching player statistic")
        
        setplatform=userdata["setplatform"]
        setplayername=userdata["setplayername"]
        self.ui.statsshow.clear()
        try:
            #print"trying to search for unique player"
            search_player=urllib.urlopen("http://api.bfbcs.com/api/"+str(setplatform)+"?search="+str(setplayername))
            testvalidity=search_player.read()
            testvalidityconverted=json.loads(testvalidity)
            found=testvalidityconverted[u'found_exact']
            #print found
            
            
            if found == True:
                #print "Found = True"
                    #Load general stats
                self.ui.stats=urllib.urlopen("http://api.bfbcs.com/api/"+str(setplatform)+
                                                 "?players="+str(setplayername)+",&fields=all,online")
                statistic=self.ui.stats.read()
                converted=json.loads(statistic)
                    
                    #Load global stats

                self.parse_general(converted)
                #print"unique player found: "+str(setplayername)
            elif found== False:
                self.ui.statsshow.setText("Playername is not specified enough.Please enter a correct name") 
                   
            
        except:
            self.ui.statsshow.setText("There might be a problem with your internet connection, or stats service is temporarily unreachable!")
            
            

            
    
            
            
            
    def parse_general(self,converted):
        #dictionary1 general
        goldedition=converted[u'players'][0][u'general'][u'goldedition'] 
        rankname=converted[u'players'][0][u'rank_name']#
        name=converted[u'players'][0][u'name']#
        lastcheck=converted[u'players'][0][u'date_lastcheck'] 
        deaths=converted[u'players'][0][u'deaths']  
        sc_vehicle=converted[u'players'][0][u'general'][u'sc_vehicle']
        spm=converted[u'players'][0][u'general'][u'spm']
        sc_team=converted[u'players'][0][u'general'][u'sc_team']
        sc_award=converted[u'players'][0][u'general'][u'sc_award']
        udogt=converted[u'players'][0][u'general'][u'udogt']
        sc_general=converted[u'players'][0][u'general'][u'sc_general']
        slevel=converted[u'players'][0][u'general'][u'slevel']#
        sc_support=converted[u'players'][0][u'general'][u'sc_support']
        dogt=converted[u'players'][0][u'general'][u'dogt']
        dogr=converted[u'players'][0][u'general'][u'dogr']
        accuracy=converted[u'players'][0][u'general'][u'accuracy']
        elo0=converted[u'players'][0][u'general'][u'elo0']
        elo1=converted[u'players'][0][u'general'][u'elo1']
        sc_assault=converted[u'players'][0][u'general'][u'sc_assault']
        sc_bonus=converted[u'players'][0][u'general'][u'sc_bonus']
        sc_recon=converted[u'players'][0][u'general'][u'sc_recon']
        #sc_engineer=converted[u'players'][0][u'general'][u'sc_engineer']
        sc_objective=converted[u'players'][0][u'general'][u'sc_objective']
        teamkills=converted[u'players'][0][u'general'][u'teamkills']
        wins=converted[u'players'][0][u'general'][u'wins']
        losses=converted[u'players'][0][u'general'][u'losses']
        sc_demo=converted[u'players'][0][u'general'][u'sc_demo']
        sveteran=converted[u'players'][0][u'general'][u'sveteran']
        games=converted[u'players'][0][u'general'][u'games']
        sc_squad=converted[u'players'][0][u'general'][u'sc_squad']
        spm0=converted[u'players'][0][u'general'][u'spm0']
        spm1=converted[u'players'][0][u'general'][u'spm1']
        clantag=converted[u'players'][0][u'clantag']
        lastonline=converted[u'players'][0][u'lastonline']
        score=converted[u'players'][0][u'score']
        platform=converted[u'players'][0][u'platform']
        veteran=converted[u'players'][0][u'veteran']
        date_lastupdate=converted[u'players'][0][u'date_lastupdate']
        kills=converted[u'players'][0][u'kills']
        elo=converted[u'players'][0][u'elo']
        level=converted[u'players'][0][u'level']
        lastcheck=converted[u'players'][0][u'lastcheck']
        form=converted[u'players'][0][u'form']
        times=converted[u'players'][0][u'time']#
        rank=converted[u'players'][0][u'rank'] 
        
        
        
        #Calculations
        
        timeshow=round((times/3600),2)
        skilllevel=int(elo)
        kd=float(kills)/float(deaths)
        kdratio=round(kd,2)
        wl=float(wins)/float(losses)
        wlratio=round(wl,2)
        accuracy=int(accuracy*100)
        #dictionary 2 global
        
        
        
        
        
        
        
        
        
        #Zusätzliche Variabeländerungen
        
        if clantag=="":
            clantag="None"
        if platform=="360":
            platform="Xbox 360" 
        if lastcheck=="nochange":
            lastcheck="Nothing has changed\nsince last check\n"
            changeinfo=""
        else:
            pass    
            

        
        
        
        
        #Anzeige

        self.ui.statsshow.setText("General:\n\n"+str(changeinfo)+str(lastcheck)+"\n"
                                  "Playername: "+str(name)+"\n"
                                  "Platform: "+str(platform)+"\n"
                                  "Rank: "+str(rankname)+"\n"
                                  "Rank: "+str(rank)+"\n"
                                  "Veteranstatus: "+str(veteran)+"\n"
                                  "Level: "+str(level)+"\n"
                                  "Skill-Level: "+str(skilllevel)+"\n"
                                  "\nScores:\n\n"
                                  "Score: "+str(score)+"\n"
                                  "Team score: "+str(sc_team)+"\n"
                                  "Squad score: "+str(sc_squad)+"\n"
                                  "General score: "+str(sc_general)+"\n"
                                  "Award score: "+str(sc_award)+"\n"
                                  "Objective score: "+str(sc_objective)+"\n"
                                  "Demolition score: "+str(sc_demo)+"\n"
                                  "Recon score: "+str(sc_recon)+"\n"
                                  "Assault score: "+str(sc_assault)+"\n"
                                  "Support score: "+str(sc_support)+"\n"
                                  "Vehicle score: "+str(sc_vehicle)+"\n"
                                  "Bonus score: "+str(sc_bonus)+"\n"
                                  "\nDetails:\n\n"
                                  "Kills: "+str(kills)+"\n"
                                  "Deaths: "+str(deaths)+"\n"
                                  "K/D Ratio: "+str(kdratio)+"\n"
                                  "Teamkills: "+str(teamkills)+"\n"
                                  "Games played: "+str(games)+"\n"
                                  "Wins: "+str(wins)+"\n"
                                  "Losses: "+str(losses)+"\n"
                                  "Win/Lose-Ratio: "+str(wlratio)+"\n"
                                  "Time played: "+str(timeshow)+" h\n"
                                  "Last online: "+str(lastonline)+"\n"
                                  "Clantag: "+str(clantag)+"\n"
                                  "Accuracy: "+str(accuracy)+"\n"
                                  "Dogtags: "+str(dogt)+"\n"
                                  "Form: "+str(form)+"\n"
                                  "Last update: "+str(date_lastupdate)+"\n")
                    #"Engineer: "+str(sc_engineer)+"\n")
        

        
        
        
        
    def get_stats_global(self):
        setplatform=self.ui.platform.currentText()
        try:
            globalstats=urllib.urlopen("http://api.bfbcs.com/api/"+str(setplatform)+"?globalstats")
            globalstatistic=globalstats.read()
            globalconverted=json.loads(globalstatistic)
            
            playerspc=globalconverted[u'players_pc']
            playersxbox=globalconverted[u'players_360']
            playersps3=globalconverted[u'players_ps3']
            #serverpc=globalconverted[u's_pc'][0]['servers']
            
            
            
            self.ui.statsshow.setText("Global:\n\n"
                                      "Pc players: "+str(playerspc)+"\n"                                      
                                      "Xbox players: "+str(playersxbox)+"\n"
                                      "Ps3 players: "+str(playersps3)+"\n")
            #"Servers Pc: "+str(serverpc)+"\n"
            
            
            
        except:
            self.ui.statsshow.setText("No internet connection available or stats server down.")  
                    
    
        
         
             
    def set_as_default(self):
        activatestate=self.ui.activate.checkState()
        if activatestate==False:
            #print "Deaktivated"
            
            default=open("/home/user/MyDocs/.bfbc2stats/defaultplayer.ini","w")
               
            #default=open("defaultplayer.ini","w")
            default.write("")
            default.close
        else:
            #print "Activated"    
            
            
            setplatform=self.ui.platform.currentText()
            setplayername=self.ui.playername.text() 
            index=self.ui.platform.currentIndex()
            if setplayername=="":
                self.ui.statsshow.setText("You have to enter a valid player name to set as default!")
                self.ui.activate.setChecked(False)
            else:
                #print"Userdatei schreiben"
                #try:
                default=open("/home/user/MyDocs/.bfbc2stats/bfbc2statsinformation.ini","w")
                #except:    
                    #default=open("defaultplayer.ini","w")
               
                userdata={"setplayername":setplayername, 
                          "setplatform":setplatform,
                          "index":str(index)}
                
                for data in userdata:
                    default.write(data+" " + userdata[data]+"\n")
                default.close()
                
                 
                #Write cache
                  
                cache=self.ui.statsshow.toPlainText()
                if cache!="":
                    #try:
                    fobj=open("/home/user/MyDocs/.bfbc2stats/bfbc2statscache.ini","w")
                    #except:    
                        #fobj=open("bfbc2statscache.ini","w")
                    fobj.write(cache)
                    fobj.close()
                else:
                    pass    
                

    def information(self):
        #import connect
        
        try:
            getinfo=urllib.urlopen("http://nachbar90.alfahosting.org/bfbc2stats/information.ini")
            getinformation=getinfo.read()
            self.ui.statsshow.setText(str(getinformation))
            #try:
            fobj=open("/home/user/MyDocs/.bfbc2stats/bfbc2statsinformation.ini","w")
            #except:     
                #fobj=open("bfbc2statsinformation.ini","w")
            fobj.write(getinformation)
            fobj.close()
        except:
            
            if os.path.isfile("/home/user/MyDocs/.bfbc2stats/bfbc2statsinformation.ini"):
                #try:
                fobj=open("/home/user/MyDocs/.bfbc2stats/bfbc2statsinformation.ini","r")
                #except:    
                    #fobj=open("bfbc2statsinformation.ini","r") 
                information=fobj.read()
                self.ui.statsshow.setText(information)
                fobj.close()
                
                
                
            else:
                self.ui.statsshow.setText("No internet connection established")             
            
            
    def minimizefunc(self):#Experimentell, schließt statt zu minimieren
        subprocess.Popen(['dbus-send', '--type=signal', '--session', '/com/nokia/hildon_desktop', 'com.nokia.hildon_desktop.exit_app_view'])        
            
    def closefunc(self):#Methode zum Schließen des Mainwindows
        sys.exit()
            
        
        
app = QtGui.QApplication(sys.argv)
main = MainWindow()
sys.exit(app.exec_())        