program vpkg;

{$mode objfpc}{$H+}

uses
  vnode, Classes, SysUtils, zstream, vdf, vds, idea, fgl
  { add your units here };
  
  
type

{ TVDataCreator }

TVDataCreator = class(TVObject)
  Name     : AnsiString;
  Stream   : TFileStream;
  Header   : TVDFHeader;
  Data     : TVDCHArray;
  ASize    : DWord;
  EKey     : TIDEAKey;
  constructor Create(aFileName : AnsiString);
  procedure  AddFile(aFileName : AnsiString; aFlags : TVDFClumpFlags = []; PackageName : AnsiString = '');
  procedure  AddDir(aDirName : AnsiString; aFlags : TVDFClumpFlags = []; PackageName : AnsiString = '');
  destructor Destroy; override;
  private
  procedure  Flush;
  function FileToStream(FHead : TVDFClumpHeader) : DWord;
end;

{ TVDataCreator }

constructor TVDataCreator.Create(aFileName: AnsiString);
begin
  Header.Signature := VDF_SIGNATURE;
  Header.Version   := 0;
  Header.Files     := 0;
  Stream           := nil;
  Name             := aFileName;
  ASize            := 256;
  SetLength(Data,ASize);
end;

procedure TVDataCreator.AddFile(aFileName: AnsiString; aFlags: TVDFClumpFlags; PackageName : AnsiString = '');

function FileSize(FName : AnsiString) : DWord;
var TF : File of byte;
begin
  Assign(TF,FName);
  Reset(TF);
  FileSize := System.FileSize(TF);
  Close(TF);
end;

begin
  if not FileExists(aFileName) then raise EFOpenError.Create('File "'+aFileName+'" not found!');
  Log('Adding "'+aFileName+'"...');
  if Header.Files+2 >= ASize then
  begin
    ASize := 2*ASize;
    SetLength(Data,ASize);
  end;
  
  with Data[Header.Files] do
  begin
    if PackageName = '' then
      Name  := aFileName
    else
      Name  := PackageName;
      
    Dir   := aFileName;
    Size  := FileSize(aFileName);
    Pos   := 0;
    Flags := aFlags;
  end;

  Inc(Header.Files);
end;

procedure TVDataCreator.AddDir(aDirName: AnsiString; aFlags: TVDFClumpFlags; PackageName : AnsiString = '');
var SearchRec : TSearchRec;
begin
  Log('Adding directory "'+aDirName+'"...');
  if FindFirst(aDirName + PathDelim + '*',faAnyFile,SearchRec) = 0 then
  repeat
    if SearchRec.Name[1] = '.' then Continue;
    if PackageName = '' then
      AddFile(aDirName + PathDelim + SearchRec.Name, aFlags)
    else
      AddFile(aDirName + PathDelim + SearchRec.Name, aFlags, PackageName + PathDelim + SearchRec.Name);
  until (FindNext(SearchRec) <> 0);
  FindClose(SearchRec);
end;

procedure TVDataCreator.Flush;
var Count : DWord;
    CPos  : DWord;
    Last  : DWord;
const HEAD = SizeOf(TVDFHeader);
      CLPH = SizeOf(TVDFClumpHeader);
begin
  CPos := HEAD;
  CPos += Header.Files*CLPH;
{  for Count := 0 to Header.Files - 1 do
  begin
    Data[Count].Pos := CPos;
    CPos += Data[Count].Size;
  end;}
  
  Stream := TFileStream.Create(Name,fmCreate);
  Stream.Write(Header,SizeOf(Header));
  for Count := 0 to Header.Files - 1 do
    Stream.Write(Data[Count],SizeOf(TVDFClumpHeader));
  for Count := 0 to Header.Files - 1 do
  begin
    Data[Count].Pos := CPos;
    CPos += FileToStream(Data[Count]);
  end;
  Stream.Seek(HEAD,soFromBeginning);
  for Count := 0 to Header.Files - 1 do
    Stream.Write(Data[Count],SizeOf(TVDFClumpHeader));
  FreeAndNil(Stream);
end;

destructor TVDataCreator.Destroy;
begin
  Flush;
  inherited Destroy;
end;

function TVDataCreator.FileToStream(FHead: TVDFClumpHeader) : DWord;
var FStream : TStream;
    Filter  : TStream;
    Filter2 : TStream;
    Before  : DWord;
begin
  Before  := Stream.Position;
  Filter  := nil;
  Filter2 := nil;
  FStream := TFileStream.Create(FHead.Dir,fmOpenRead);
  Writeln(FHead.Name);
  if (vdfEncrypted in FHead.Flags) and (vdfCompressed in FHead.Flags) then
  begin
    Filter := FStream;
    Filter2 := TIDEAEncryptStream.Create(EKey,Stream);
    FStream := TCompressionStream.Create(clDefault,Filter2,False);
    FStream.CopyFrom(Filter,Filter.Size);
  end
  else
  if vdfEncrypted in FHead.Flags then
  begin
    Filter := FStream;
    FStream := TIDEAEncryptStream.Create(EKey,Stream);
    FStream.CopyFrom(Filter,Filter.Size);
  end
  else
  if vdfCompressed in FHead.Flags then
  begin
    Filter := FStream;
    FStream := TCompressionStream.Create(clDefault,Stream,False);
    FStream.CopyFrom(Filter,Filter.Size);
  end
  else
  begin
    Stream.CopyFrom(FStream,FStream.Size);
  end;
  FreeAndNil(Filter);
  FreeAndNil(FStream);
  FreeAndNil(Filter2);
 //  while (Stream.Position - Before) mod 8 <> 0 do Stream.WriteByte(0);
  Exit(Stream.Position - Before);
end;

var Test : TVDataCreator;
    DF   : TVDataFile;
    FS   : TStream;
    c    : Word;
    
    EKey,DKKey : TIDEAKey;
const
    UserKey : TIdeaCryptKey = (123,111,10,12,222,0,1,8);

const x : string[7] = 'ahello!';

var y, z : string[7];

type TQueueElement = class
    Priority : DWord;
    constructor Create(P : DWord);
    procedure Report;
  end;

constructor TQueueElement.Create(P : DWord);
begin
  Priority := P;
end;

procedure TQueueElement.Report;
begin
  Writeln('Event:',Priority);
end;

function QECompare(const Item1,Item2 : TQueueElement) : Integer;
begin
       if Item1.Priority < Item2.Priority then Exit(1)
  else if Item1.Priority > Item2.Priority then Exit(-1)
  else Exit(0);
end;



type TMyQueue = specialize THeapQueue<TQueueElement>;

var //AR : TLongArray;
    l : Byte;
    r : DWord;
    MQ : TMyQueue;
    QE : TQueueElement;

begin
 { AR := TLongArray.Create(16,0,True);
  AR[5] := 10;
  AR[7] := TKlass.Create(2);
  for l := 1 to 13 do begin Write(l,':'); if AR[l] <> nil then AR[l].Report; Writeln;end;
  FreeAndNil(AR);
  Writeln(GetEnvironmentVariable('USERPROFILE'));
  Readln;}

  MQ := TMyQueue.Create;
  MQ.OnCompare := @(QECompare);
  
  for l := 1 to 20 do
  begin
    r := Random(1000);
    Writeln('Adding event #',r);
    MQ.Add(TQueueElement.Create(r));
  end;

  Write('Peek :');
  MQ.Peek.Report;

  Writeln('Pop 5...');
  for l := 1 to 5 do
  begin
    QE := MQ.Pop;
    QE.Report;
    FreeAndNil(QE);
  end;

  Write('Peek :');
  MQ.Peek.Report;

  for l := 1 to 10 do
  begin
    r := Random(1000);
    Writeln('Adding event #',r);
    MQ.Add(TQueueElement.Create(r));
  end;

  Write('Peek :');
  MQ.Peek.Report;

  Writeln('Poping...');
  while not MQ.IsEmpty do
  begin
    QE := MQ.Pop;
    QE.Report;
    FreeAndNil(QE);
  end;
  Writeln('Done.');

  Readln;
  

 { EnKeyIdea(UserKey,EKey);
  DeKeyIdea(EKey,DKKey);
  


  Test := TVDataCreator.Create('doom.vdf');
  Test.EKey := EKey;
  Test.AddDir('C:\Projects\DoomRL\bin\music',[vdfCompressed],'music');
  Test.AddDir('C:\Projects\DoomRL\bin\wav',[vdfCompressed],'wav');
  Test.AddDir('C:\Projects\DoomRL\bin\lua',[vdfEncrypted,vdfCompressed],'lua');
//  Test.AddDir('C:\Projects\DoomRL\bin\mp3',[],'mp3');

  DF := TVDataFile.Create('doom.vdf');
  DF.DKKey := DKKey;
  FS := DF.GetFile('lua\ranks.lua');
  for c := 0 to 3043 do Write(Char(FS.ReadByte));
  FreeAndNil(DF);}
end.

