program vluatest;
{$mode objfpc}{$H+}
uses
  Classes, SysUtils, lua, vluatools, vlua;

var Command, Error : AnsiString;
    TestLua     : TLua;
    Stack, Code : Integer;

function print_value(L: Plua_State; index : Integer; Indent : Word = 0; Prefix : AnsiString = '') : Word;
var Lines : Byte;
begin
  index := lua_absindex(L,index);
  Prefix := StringOfChar(' ',Indent)+Prefix;
  case lua_type(L,index) of
    LUA_TNIL           : Writeln(Prefix+'nil');
    LUA_TBOOLEAN       : if lua_toboolean(L,index) then Writeln(Prefix+'true') else Writeln(Prefix+'false');
    LUA_TLIGHTUSERDATA : Writeln(Prefix+'lightuserdata(0x'+hexstr(lua_touserdata(L,index))+')');
    LUA_TNUMBER        : Writeln(Prefix+lua_tostring(L,index));
    LUA_TSTRING        : Writeln(Prefix+'"'+lua_tostring(L,index)+'"');
    LUA_TFUNCTION      : Writeln(Prefix+'function');
    LUA_TUSERDATA      : Writeln(Prefix+'userdata');
    LUA_TTHREAD        : Writeln(Prefix+'thread');
    LUA_TTABLE         :
      begin
        Writeln(Prefix+'table = {');
        Indent += 2;
        Lines := 2;
        lua_pushnil(L);
        while lua_next(L, index) <> 0 do
        begin
          // key (index -2), 'value' (index -1)
          if lua_isnumber( L, -2 ) then
            Lines += print_value( L, -1, Indent, IntToStr(lua_tointeger( L, -2 ))+' = ')
          else
            Lines += print_value( L, -1, Indent, lua_tostring( L, -2 )+' = ');
          // remove value, keep key
          lua_pop(L, 1);
          if Lines > 8 then
          begin
            Writeln(StringOfChar(' ',Indent)+'...');
            lua_pop(L, 1);
            break;
          end;
        end;
        if Lines <= 8 then Writeln(StringOfChar(' ',Indent-2)+'}');
        Exit(Lines);
      end;
  end;
  Exit(1);
end;



begin
  TestLua := TLua.Create();
  RegisterCoordClass( TestLua.LuaState );
  RegisterAreaClass( TestLua.LuaState );
  repeat
    Write(lua_gettop(TestLua.LuaState),' > ');
    Readln( Command );
    Command := Trim(Command);
    if Command = 'exit' then break;
    Stack := lua_gettop(TestLua.LuaState);

    if (Pos( '=', Command ) = 0) and (Pos( 'if', Command ) = 0) and (Pos( 'return', Command ) = 0) then
      Command := 'return '+Command;


    Code := luaL_loadstring(TestLua.LuaState, PChar(Command));
    if Code = 0 then Code := lua_pcall(TestLua.LuaState, 0, LUA_MULTRET, 0);
    if Code <> 0 then
    begin
      Error := lua_tostring(TestLua.LuaState,-1);
      Writeln('Error: '+Error);
      lua_pop(TestLua.LuaState,1);
      Continue;
    end;

    if lua_gettop(TestLua.LuaState) > Stack then
    for Code := Stack+1 to lua_gettop(TestLua.LuaState) do
      print_value(TestLua.LuaState,Code);
    lua_settop(TestLua.LuaState,Stack);

  until false;
  FreeAndNil( TestLua );
end.

