// @abstract(Valkyrie Simple Roguelike Skeleton - Entity Unit)
// @author(Kornel Kisielewicz <kisiel@fulbrightweb.org>)
// @lastmod(Jan 23, 2006)
//
// This is the player unit. It introduces TPlayer -- a class for handling the
// player -- mainly keyboard input handling.
//
// This piece of code I release to the PUBLIC DOMAIN.

{$INCLUDE valkyrie.inc}
unit srplayer;
interface
uses vnode, voutput, srentity;

// Our player class
type TPlayer = class(TEntity)
       procedure Action; override;
     end;

implementation
uses vinput, srmap;

procedure TPlayer.Action;
var key : Byte;
  // Checks wether it's ok to move to the given location
  function MoveOk(tx,ty : byte) : boolean;
  begin
    with TMap(Parent) do // Reference to our parent, the map.
    begin
      if not MapTiles[Cells[tx,ty].Tile].Passable then Exit(False); // Passability check
      if Cells[tx,ty].Entity <> nil then Exit(False) // Check if cell is already taken
    end;
  end;
begin
  TMap(Parent).Draw; // Draw our parent the map ...
  Output.Update;     // ... and let it be visible on the screen
  
  // Now query for a valid key:
  key := Input.GetKey([VKEY_UP,VKEY_DOWN,VKEY_LEFT,VKEY_RIGHT,VKEY_ESCAPE]);
  
  // Perform aquedate action:
  case key of
    VKEY_UP     : if MoveOk(xpos,ypos-1) then Move(xpos,ypos-1); // Move North
    VKEY_DOWN   : if MoveOk(xpos,ypos+1) then Move(xpos,ypos+1); // Move South
    VKEY_LEFT   : if MoveOk(xpos-1,ypos) then Move(xpos-1,ypos); // Move West
    VKEY_RIGHT  : if MoveOk(xpos+1,ypos) then Move(xpos+1,ypos); // Move East
    VKEY_ESCAPE : Finished := True;                              // Quit
  end;
end;


end.


