{$INCLUDE valkyrie.inc}
// @abstract(TextMode Input system for Valkyrie)
// @author(Kornel Kisielewicz <kisiel@fulbrightweb.org>)
// @created(May 19, 2004)
// @lastmod(Jan 14, 2006)
//
// Implements an basic textmode input system for Valkyrie, based
// on FP Keyboard.
//
//  @html <div class="license">
//  This library is free software; you can redistribute it and/or modify it
//  under the terms of the GNU Library General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or (at your
//  option) any later version.
//
//  This program is distributed in the hope that it will be useful, but WITHOUT
//  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
//  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Library General Public License
//  for more details.
//
//  You should have received a copy of the GNU Library General Public License
//  along with this library; if not, write to the Free Software Foundation,
//  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//  @html </div>

unit vtinput;
interface
uses vinput;

// The basic input class, published as the singleton @link(Output).
type TTextModeInput = class(TInput)
       // Initializes the Keyboard system.
       constructor Create; override;
       // Deinitializes the Keyboard system.
       destructor Destroy; override;
       protected
       function PollKey : Boolean; override;
       function GetVCode : byte; override;
     end;

implementation

uses keyboard, vutil, voutput, sysutils;

const InputKeyBackSpace = $0E08;
      InputKeyEnter     = $1C0D;
      InputKeyTab       = $0F09;
      InputKeyEscape    = $011B;

constructor TTextModeInput.Create;
begin
  inherited Create;
  InitKeyboard;
  Log('Terminal Keyboard system ready.');
end;

function TTextModeInput.PollKey : Boolean;
begin
  if Assigned(Output) then Output.Update;
  Sleep(10);
  PollKey := (PollKeyEvent <> 0);
end;

destructor TTextModeInput.Destroy;
begin
  //Unknown to myself, I have no clue why I get an access violation here...
  //DoneKeyboard;
  inherited Destroy;
end;

function TTextModeInput.GetVCode : Byte;
var ch : char;
    Key : TKeyEvent;
begin
  Key:=GetKeyEvent;
  Key:=TranslateKeyEvent(Key);
  ch := GetKeyEventChar(Key);
  if ch <> #0 then
    if ch in [' '..'~'] then
      Exit(Ord(ch));
  case GetKeyEventCode(Key) of
    InputKeyEscape    : Exit(VKEY_ESCAPE);
    InputKeyTab       : Exit(VKEY_TAB);
    InputKeyBackspace : Exit(VKEY_BACKSPACE);
    InputKeyEnter     : Exit(VKEY_ENTER);
    kbdInsert         : Exit(VKEY_INSERT);
    kbdDelete         : Exit(VKEY_DELETE);
    kbdHome           : Exit(VKEY_HOME);
    kbdEnd            : Exit(VKEY_END);
    kbdPgUp           : Exit(VKEY_PAGEUP);
    kbdPgDn           : Exit(VKEY_PAGEDOWN);
    kbdUp             : Exit(VKEY_UP);
    kbdDown           : Exit(VKEY_DOWN);
    kbdLeft           : Exit(VKEY_LEFT);
    kbdRight          : Exit(VKEY_RIGHT);
    19456             : Exit(VKEY_CENTER);
    kbdF1             : Exit(VKEY_F1);
    kbdF2             : Exit(VKEY_F2);
    kbdF3             : Exit(VKEY_F3);
    kbdF4             : Exit(VKEY_F4);
    kbdF5             : Exit(VKEY_F5);
    kbdF6             : Exit(VKEY_F6);
    kbdF7             : Exit(VKEY_F7);
    kbdF8             : Exit(VKEY_F8);
    kbdF9             : Exit(VKEY_F9);
    kbdF10            : Exit(VKEY_F10);
    kbdF11            : Exit(VKEY_F11);
    kbdF12            : Exit(VKEY_F12);
  end;
  Exit(0);
end;

end.
{
LOG:
2006-JAN-14 Updated to Valkyrie 2
}
