{$INCLUDE valkyrie.inc}
unit vtextui;
{$H+}
interface
uses Classes, SysUtils, vmath, vutil, voutput, vinput, vui;

// TODO
// -- text viewer
// -- caching of AD and WS
// -- snipping widh/height to parent?

{ TTextUIElement }

type

{ TTextWindow }

TTextUIWindow = class(TUIWindow)
  procedure Draw; override;
end;

{ TTextContent }

TTextUIContent = class(TUIContent)
  procedure Draw; override;
end;

{ TTextUISeparator }

TTextUISeparator = class(TUISeparator)
  procedure Draw; override;
end;

type TTextUIViewer = class(TUIViewer)
  constructor Create(newParent : TUIElement; newTitle : Ansistring); reintroduce;
  // Draws the current state
  procedure Draw; override;
end;

type TTextUIFullViewer = class(TUIFullViewer)
  constructor Create(newParent : TUIElement; newNoBars : boolean; newTitle : Ansistring); reintroduce;
  // Draws the current state
  procedure Draw; override;
  private
  NoBars : Boolean;
end;

type TTextUIInputLine = class(TUIInputLine)
  // Draws the widget to screen.
  procedure Draw; override;
end;

type TTextUIStringListArea = class(TUIStringListArea)
  // Draws the strings to screen. lower ones are on top.
  procedure Draw; override;
end;

// TextMode version of the TMessages class from Roguelike Tools.
type

{ TTextUIMessages }

TTextUIMessages = class(TUIMessages)
    constructor Create(newParent : TUIElement; nBufferSize : Word = 1000; const nOptions : TFlags32 = []; const nMoreText : string = '@B[more]'); reintroduce;
    // Draws the messages to screen.
    procedure Draw; override;
    // Prints a more message and waits for enter.
    procedure More; override;
  private
    DrawMore : Boolean;
  end;
  
type TTextUIMap = class(TUIMap)
    // Draws the map to screen.
    procedure Draw; override;
  end;



implementation
{ TTextUIPanel }

procedure TTextUIWindow.Draw;
var AD : TRect;
    C  : Byte;
begin
  if not Visible then Exit; // and don't draw children!
  AD := AbsoluteDimensions;
  Output.ClearRectColor(AD,Style^.BackColor);
  if Framed then
  begin
    for C := AD.X1+1 to AD.X2-1 do Output.DrawChar(C,AD.Y1,Style^.FrameColor,Style^.Frame[1]);
    for C := AD.X1+1 to AD.X2-1 do Output.DrawChar(C,AD.Y2,Style^.FrameColor,Style^.Frame[3]);
    for C := AD.Y1+1 to AD.Y2-1 do Output.DrawChar(AD.X1,C,Style^.FrameColor,Style^.Frame[2]);
    for C := AD.Y1+1 to AD.Y2-1 do Output.DrawChar(AD.X2,C,Style^.FrameColor,Style^.Frame[4]);
    Output.DrawChar(AD.X1,AD.Y1,Style^.FrameColor,Style^.Frame[5]);
    Output.DrawChar(AD.X2,AD.Y1,Style^.FrameColor,Style^.Frame[6]);
    Output.DrawChar(AD.X1,AD.Y2,Style^.FrameColor,Style^.Frame[7]);
    Output.DrawChar(AD.X2,AD.Y2,Style^.FrameColor,Style^.Frame[8]);
  end;
  if Title <> '' then Output.CenterDrawString(AD.X1+AD.w div 2-1,AD.Y1,Style^.TitleColor,' '+Title+' ');
  inherited Draw;
end;

{ TUIContent }

procedure TTextUIContent.Draw;
var AD : TRect;
begin
  AD := getAbsoluteDimensions;
//  Output.ClearRect(AD);
  if LineBreak then
    Output.DrawString(AD.X1,AD.Y1,Style^.MainColor,Text,Dimensions.GetWidth+1)
  else
    Output.DrawString(AD.X1,AD.Y1,Style^.MainColor,Text);
  inherited Draw;
end;


procedure TTextUISeparator.Draw;
var C  : byte;
    AD : TRect;
begin
  inherited Draw;
  AD := AbsoluteDimensions;
  if Horizontal then
    for C := AD.x1-LengthBonus to AD.x2+LengthBonus do
      Output.DrawChar(C,Position+AD.y1-1,Style^.FrameColor,Style^.Frame[1])
  else
    for C := AD.y1-LengthBonus to AD.y2+LengthBonus do
      Output.DrawChar(Position+AD.x1-1,C,Style^.FrameColor,Style^.Frame[2]);
end;

procedure TTextUIStringListArea.Draw;
var AD : TRect;
    cn : DWord;
    ps : Integer;
begin
  AD := getAbsoluteDimensions;
  Output.ClearRectColor(AD,Style^.BackColor);
  if (StringList = nil) or (StringList.IsEmpty) then Exit;
  for cn := 1 to AD.GetHeight do
  begin
    ps := Position+cn-1;
    if ps < 0 then Continue;
    Output.DrawString(AD.x1,AD.y1+LongInt(cn-1),Style^.MainColor,StringList[ps])
  end;
end;

procedure TTextUIInputLine.Draw;
var AD : TRect;
begin
  AD := getAbsoluteDimensions;
  Output.ClearRectColor(AD.x1,AD.y1,AD.x1+Len,AD.y1,Style^.BackColor);
  Output.PrintString(AD.x1,AD.y1,Style^.BoldColor,Value);
  Output.MoveCursor(AD.x1+Position,AD.y1);
end;

constructor TTextUIViewer.Create(newParent: TUIElement; newTitle: Ansistring);
begin
  inherited Create(newParent, newTitle);
  StringArea := TTextUIStringListArea.Create(Self);
  StringArea.Dimensions.y1 += 2;
  StringArea.Dimensions.y2 -= 2;
end;

procedure TTextUIViewer.Draw;
var uc,dc : char;
    AD    : TRect;
    cn    : DWord;
    last  : DWord;
begin
  AD := getAbsoluteDimensions;
  uc := ''; dc := ''; {end else begin uc := '^'; dc := 'v'; rc := '-' end;}
  last := TextLines;
  Output.ClearRectColor(AD,Style^.BackColor);
  Output.DrawString(AD.x1+2,AD.y1,Style^.TitleColor,Title);
  Output.DrawString(AD.x1+2,AD.y2,Style^.MainColor,'Use arrows to scroll, PgUp, PgDown. Escape or Enter exits.');
  if last > 0 then
    Output.LeftDrawString(AD.x2-10,AD.y1,Style^.MainColor,FloatToStrF((StringArea.Position/last*100),ffFixed,0,0)+'%');

  for cn := AD.x1 to AD.x2 do Output.DrawChar(cn,AD.y1+1,Style^.FrameColor,Style^.Frame[1]);
  for cn := AD.x1 to AD.x2 do Output.DrawChar(cn,AD.y2-1,Style^.FrameColor,Style^.Frame[1]);

  if StringArea.Position = 0 then uc := ' ';
  Output.DrawChar(AD.x2-1,AD.y1+1,LightBlue,uc);
  Output.DrawChar(AD.x1+2,AD.y1+1,LightBlue,uc);
  if StringArea.Position >= last then dc := ' ';
  Output.DrawChar(AD.x2-1,AD.y2-1,LightBlue,dc);
  Output.DrawChar(AD.x1+1,AD.y2-1,LightBlue,dc);
  inherited Draw;
end;

{ TTextUIMessages }

constructor TTextUIMessages.Create(newParent: TUIElement; nBufferSize: Word; const nOptions: TFlags32;
  const nMoreText: string);
begin
  inherited Create(newParent, nBufferSize, nOptions, nMoreText);
  DrawMore := False;
end;

procedure TTextUIMessages.Draw;
var cy : Word;
    AD    : TRect;
begin
  AD := getAbsoluteDimensions;
  Output.ClearRectColor(AD,Style^.BackColor);
  if FActive > 0 then
  for cy := 0 to Min(FActive-1,AD.getHeight-1) do
    Output.DrawString(AD.X1,AD.Y2-cy,LightGray,Get(cy),True);
  if not (UIMSG_UPDATECLEAR in FOptions) then
  for cy := FActive to AD.getHeight-1 do
    Output.DrawString(AD.X1,AD.Y2-cy,DarkGray,Get(cy));
  if DrawMore then
    Output.DrawString(AD.X1+AD.GetWidth-FMoreLength-1,AD.Y1+AD.GetHeight-1,LightGray,FMoreText);
end;

procedure TTextUIMessages.More;
var AD    : TRect;
begin
  DrawMore := True;
  AD := getAbsoluteDimensions;
  Output.DrawString(AD.X1+AD.GetWidth-FMoreLength-1,AD.Y1+AD.GetHeight-1,LightGray,FMoreText);
  Input.GetKey([VKEY_ENTER,Ord(' ')]);
  DrawMore := False;
end;

{ TTextUIMap }

procedure TTextUIMap.Draw;
var x,y   : Word;
  procedure DrawTile(sx,sy : LongInt);
  var wx, wy : LongInt;
  begin
    wx := WorldX(sx);
    wy := WorldY(sy);
    if UIMAP_TRUECOLOR in FOptions
      then Output.DrawPicture(sx,sy,FMap.getASCII(wx,wy),FMap.getColor(wx,wy))
      else Output.DrawPicture(sx,sy,FMap.getASCII(wx,wy));
    if (UIMAP_MARKING in FOptions) and (MarkMap[sx-FADim.x1,sy-FADim.y1] <> 0) then
      Output.DrawPicture(sx,sy,MarkMap[sx-FADim.x1,sy-FADim.y1]);
  end;
begin
  FADim := getAbsoluteDimensions;
  for x := FADim.x1 to FADim.x2 do
    for y := FADim.y1 to FADim.y2 do
      DrawTile(x,y);
  if UIMAP_CURSOR in FOptions then Output.MoveCursor(ScreenX(FX),ScreenY(FY));
end;

{ TTextUIFullViewer }

constructor TTextUIFullViewer.Create(newParent: TUIElement; newNoBars : boolean; newTitle: Ansistring);
begin
  inherited Create(newParent, newTitle);
  NoBars := newNoBars;
  StringArea := TTextUIStringListArea.Create(Self);
  StringArea.Dimensions.y1 += 2;
  StringArea.Dimensions.y2 -= 2;
  if StringList <> nil then
  SetText(StringList);
end;

procedure TTextUIFullViewer.Draw;
var uc,dc : char;
    AD    : TRect;
    cn    : DWord;
    last  : DWord;
begin
  AD :=  getAbsoluteDimensions;
  uc := ''; dc := ''; {end else begin uc := '^'; dc := 'v'; rc := '-' end;}
  last := TextLines;
  if NoBars then
    Output.ClearRectColor(Area.Dimensions,Style^.BackColor)
  else
  begin
    Output.ClearRectColor(AD,Style^.BackColor);
    Output.DrawString(AD.x1+2,AD.y1,Style^.TitleColor,Title);
    Output.DrawString(AD.x1+2,AD.y2,Style^.MainColor,'Use arrows to scroll, PgUp, PgDown. Escape or Enter exits.');
    for cn := AD.x1 to AD.x2 do Output.DrawChar(cn,AD.y1+1,Style^.FrameColor,Style^.Frame[1]);
    for cn := AD.x1 to AD.x2 do Output.DrawChar(cn,AD.y2-1,Style^.FrameColor,Style^.Frame[1]);
  end;

  Output.LeftDrawString(AD.x2-9,AD.y1,Style^.MainColor,'     ');
  if last > 0 then
    Output.LeftDrawString(AD.x2-10,AD.y1,Style^.MainColor,FloatToStrF((StringArea.Position/last*100),ffFixed,0,0)+'%');

  if StringArea.Position > 0    then Output.DrawChar(AD.x2-2,AD.y1+1,LightBlue,uc);
  if StringArea.Position > 0    then Output.DrawChar(AD.x1+2,AD.y1+1,LightBlue,uc);
  if StringArea.Position < last then Output.DrawChar(AD.x2-2,AD.y2-1,LightBlue,dc);
  if StringArea.Position < last then Output.DrawChar(AD.x1+2,AD.y2-1,LightBlue,dc);

  inherited Draw;
end;

end.

