// @abstract(SDL Input system for Valkyrie)
// @author(Kornel Kisielewicz <kisiel@fulbrightweb.org>)
// @created(Jan 22, 2007)
// @lastmod(Jan 22, 2007)
//
// Implements an basic SDL input system for Valkyrie
//
//  @html <div class="license">
//  This library is free software; you can redistribute it and/or modify it
//  under the terms of the GNU Library General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or (at your
//  option) any later version.
//
//  This program is distributed in the hope that it will be useful, but WITHOUT
//  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
//  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Library General Public License
//  for more details.
//
//  You should have received a copy of the GNU Library General Public License
//  along with this library; if not, write to the Free Software Foundation,
//  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//  @html </div>

{$INCLUDE valkyrie.inc}
unit vsdlinput;
interface
uses vinput;

// The basic input class, published as the singleton @link(Output).
type TSDLInput = class(TInput)
       // Initializes the Keyboard system.
       constructor Create; override;
       // Deinitializes the Keyboard system.
       destructor Destroy; override;
       protected
       function PollKey : Boolean; override;
       function GetVCode : byte; override;
     end;

implementation

uses SysUtils, SDL, voutput;

function SDLEventFilter(event: PSDL_Event) : Integer; cdecl;
begin
  if Event^.type_ = SDL_QUITEV then begin  QuitApplication; Halt(0); end;
  if Event^.type_ = SDL_KEYDOWN then
    if ((event^.key.keysym.sym = SDLK_RETURN) and (event^.key.keysym.modifier and KMOD_ALT <> 0)) or
       ((event^.key.keysym.sym = SDLK_F12)    and (event^.key.keysym.modifier and KMOD_CTRL <> 0)) then
      if Assigned(Output) then
      begin
        Output.ToggleFullScreen;
        Exit(0);
      end;
      
  Exit(1);
end;

constructor TSDLInput.Create;
begin
  inherited Create;
  SDL_EventState(SDL_KEYUP, SDL_IGNORE);
  SDL_EventState(SDL_MOUSEMOTION, SDL_IGNORE);
  SDL_EventState(SDL_MOUSEBUTTONDOWN, SDL_IGNORE);
  SDL_EventState(SDL_MOUSEBUTTONUP, SDL_IGNORE);
//  SDL_EventState(SDL_SYSWMEVENT, SDL_IGNORE);
  SDL_EventState(SDL_VIDEORESIZE, SDL_IGNORE);
  SDL_EventState(SDL_VIDEOEXPOSE, SDL_IGNORE);
  SDL_EventState(SDL_USEREVENT, SDL_IGNORE);
  
  SDL_SetEventFilter(@SDLEventFilter);

  SDL_EnableUNICODE(1);
  SDL_EnableKeyRepeat(SDL_DEFAULT_REPEAT_DELAY, SDL_DEFAULT_REPEAT_INTERVAL);
end;

function TSDLInput.PollKey : Boolean;
var event : TSDL_Event;
begin
  if Assigned(Output) then Output.Update;
  Sleep(1);
  SDL_PumpEvents();
  PollKey := (SDL_PeepEvents(@event, 1, SDL_PEEKEVENT, SDL_KEYDOWNMASK) > 0);
end;

destructor TSDLInput.Destroy;
begin
  //DoneKeyboard;
  inherited Destroy;
end;

function TSDLInput.GetVCode : Byte;
var ch : char;
    event : TSDL_Event;
begin
  while SDL_PollEvent( @event ) <> 0 do
  case event.type_ of
    SDL_KEYDOWN : break;
    SDL_QUITEV  : Halt(0);
  end;
  ch := Char(event.key.keysym.unicode);
  if ch <> #0 then
    if ch in [' '..'~'] then
      Exit(Ord(ch));
  case event.key.keysym.sym of
    SDLK_Escape         : Exit(VKEY_ESCAPE);
    SDLK_Tab            : Exit(VKEY_TAB);
    SDLK_Backspace      : Exit(VKEY_BACKSPACE);
    SDLK_Return         : Exit(VKEY_ENTER);
    SDLK_Insert         : Exit(VKEY_INSERT);
    SDLK_Delete         : Exit(VKEY_DELETE);
    SDLK_Home           : Exit(VKEY_HOME);
    SDLK_End            : Exit(VKEY_END);
    SDLK_PageUp         : Exit(VKEY_PAGEUP);
    SDLK_PageDown       : Exit(VKEY_PAGEDOWN);
    SDLK_Up             : Exit(VKEY_UP);
    SDLK_Down           : Exit(VKEY_DOWN);
    SDLK_Left           : Exit(VKEY_LEFT);
    SDLK_Right          : Exit(VKEY_RIGHT);
    SDLK_F1             : Exit(VKEY_F1);
    SDLK_F2             : Exit(VKEY_F2);
    SDLK_F3             : Exit(VKEY_F3);
    SDLK_F4             : Exit(VKEY_F4);
    SDLK_F5             : Exit(VKEY_F5);
    SDLK_F6             : Exit(VKEY_F6);
    SDLK_F7             : Exit(VKEY_F7);
    SDLK_F8             : Exit(VKEY_F8);
    SDLK_F9             : Exit(VKEY_F9);
    SDLK_F10            : Exit(VKEY_F10);
    SDLK_F11            : Exit(VKEY_F11);
    SDLK_F12            : Exit(VKEY_F12);
    // TEMPORARY
    SDLK_KP1            : Exit(VKEY_END);
    SDLK_KP2            : Exit(VKEY_DOWN);
    SDLK_KP3            : Exit(VKEY_PAGEDOWN);
    SDLK_KP4            : Exit(VKEY_LEFT);
    SDLK_KP5            : Exit(Ord('.'));
    SDLK_KP6            : Exit(VKEY_RIGHT);
    SDLK_KP7            : Exit(VKEY_HOME);
    SDLK_KP8            : Exit(VKEY_UP);
    SDLK_KP9            : Exit(VKEY_PAGEUP);
    SDLK_KP_ENTER       : Exit(VKEY_NUM_ENTER);
  end;
  Exit(0);
end;

end.
{
LOG:
2006-JAN-14 Updated to Valkyrie 2
}
