// @abstract(BerserkRL -- User Interface/Text screens class)
// @author(Kornel Kisielewicz <admin@chaosforge.org>)
// @created(Jan 9, 2007)
// @lastmod(Jan 9, 2007)
//
// This unit holds the User Interface Text screens subclass of Berserk!. It's
// a subclass created to cut the size of the BerserkUI class.
//
//  @html <div class="license">
//  This file is part of BerserkRL.
//
//  BerserkRL is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  BerserkRL is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with BerserkRL; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
//  @html </div>unit brui;

{$include brinclude.inc}

unit bruitext;
{$mode objfpc}
interface

type

{ TBerserkText }

TBerserkText = class
    // The intro screen
    class procedure Intro;
    // The outro screen
    class procedure Outro;
    // Shows the help screen.
    class procedure Help;
    // Shows mortem.txt
    class procedure Mortem;
    // Shows hall of fame
    class procedure HOF;
    // Shows mortem.txt
    class procedure Night;
    private
    class procedure RunHelp(Number : byte);
  end;

implementation

uses SysUtils, vutil, voutput, vinput, vtextut, brmain, brui, brhof, brplayer, brdata;

class procedure TBerserkText.Intro;
begin
  UI.DrawFire;
  UI.Window(17,3,65,17);
  Output.DrawString(19,4,LightRed,'   #####  ### #####   #  ### ##### #  #   ## ');
  Output.DrawString(19,5,LightRed,'   #  #  ##   #  #   #  ##   #  #  #  #   ## ');
  Output.DrawString(19,6,LightRed,'   ####  # ## ####  #   # ## ####  ###    ## ');
  Output.DrawString(19,7,LightRed,'    # ## ##    # # #### ##    # #   # #   #  ');
  Output.DrawString(19,8,LightRed,'    # #   ###  # #  #    ###  # #   #  #     ');
  Output.DrawString(19,9,LightRed,'    ##    #   #  # #     #   #  #   #  #  #  ');

  Output.DrawString(19,11,LightRed,'   Berserk! - a game of tactical bloodshed ');
  Output.DrawString(19,12,LightRed,'            by Kornel Kisielewicz');
  {$IFDEF GRAPHICS}
  Output.DrawString(19,13,LightRed,'            graphics by Derek Yu ');
  {$ENDIF}

  Output.DrawString(19,15,LightGray,'  Based loosely on the Berserk universe by');
  Output.DrawString(19,16,LightGray,'               @<Kentaro Miura@> ');

  UI.Window(17,19,65,24);
  Output.DrawString(19,20,LightGray,'  Thanks to @<Turgor@>, @<Glowie@>, @<Jorge@>, @<Thomas@>,');
  Output.DrawString(19,21,LightGray,'  @<Malek@> and @<Fingerzam@> for beta testing.');
  Output.DrawString(19,22,LightGray,' ');

  Output.DrawString(19,23,LightGray,'          Press <@<Enter@>> to begin...');
  Input.GetKey([VKEY_ENTER]);
  UI.Clear;
end;

class procedure TBerserkText.Outro;
begin
  UI.DrawFire;
  UI.Window(17,3,63,22);
  Output.DrawString(20,4 ,LightGray,'Thank you for playing @<Berserk!@> This game');
  Output.DrawString(20,5 ,LightGray,'is far from finished. There are plenty of');
  Output.DrawString(20,6 ,LightGray,'features that might be implemented, with ');
  Output.DrawString(20,7 ,LightGray,'the greatest one being the @<Campaign Mode@>.');

  Output.DrawString(20,9 ,LightGray,'If you wish to support the continued deve-');
  Output.DrawString(20,10,LightGray,'lopment of @<Berserk!@> then drop me a mail at');
  Output.DrawString(20,11,LightGray,'@<admin@@chaosforge.org@>, or visit the @<Berserk!@>');
  Output.DrawString(20,12,LightGray,'forum accessible from the games website, ');
  Output.DrawString(20,13,LightGray,'and tell me what you think!');

  Output.DrawString(20,15,LightGray,'Further releases, information and source ');
  Output.DrawString(20,16,LightGray,'code available on the website:');

  Output.DrawString(20,18,White,    '  http://berserk.chaosforge.org/');

  Output.DrawString(20,20,LightGray,'                     Thanks again!');
  Output.DrawString(20,21,LightGray,'                     Kornel Kisielewicz');
  Input.GetKey([VKEY_ENTER]);
  UI.Clear;
  Output.Update;
end;


class procedure TBerserkText.Help;
var CmdCount : Byte;
    Key      : Byte;
  procedure KeyBind(desc : string; cmd : byte);
  begin
    Output.DrawString(59,5+CmdCount,LightGray,desc);
    Output.PrintString(76,5+CmdCount,White,Input.CommandToString(cmd));
    CmdCount += 1;
  end;
begin
repeat
  Output.MoveCursor(1,1);
  CmdCount := 0;
  Output.Clear;
  Output.DrawString(3,2 ,LightGray,'@<Berserk help system@>');

  Output.DrawString(5,5 ,LightGray,'[@<a@>] Getting started');
  Output.DrawString(5,6 ,LightGray,'[@<b@>] Tips and tricks');
  Output.DrawString(5,7 ,LightGray,'[@<c@>] Feedback');
  Output.DrawString(5,8 ,LightGray,'[@<d@>] Credits');
  Output.DrawString(5,9 ,LightGray,'[@<e@>] Disclaimer');

//  Output.DrawString(3,4 ,LightGray,'Berserk! is a tactical game, remember that. Basically,');
//  Output.DrawString(3,5 ,LightGray,'remember that charging without thought is never the');
//  Output.DrawString(3,6 ,LightGray,'best solution. Look out for pain -- everything higher');
//  Output.DrawString(3,7 ,LightGray,'than -2 will render your attacks practically useless.');
//  Output.DrawString(3,8 ,LightGray,'Use run mode to flee from tight spots.');

//  Output.DrawString(3,10,LightGray,'Most of all move and wait so the enemy can''t land');
//  Output.DrawString(3,11,LightGray,'a blow on you -- look at the enemies movements.');
//  Output.DrawString(3,12,LightGray,'Remember about your arsenal, but don''t waste it on');
//  Output.DrawString(3,13,LightGray,'small fry. Try to find a tactical position, but leave');
//  Output.DrawString(3,14,LightGray,'it when overwhelmed.');

//  Output.DrawString(3,16,LightGray,'Don''t worry about winning -- there is no winning.');
//  Output.DrawString(3,17,LightGray,'Just try to sell your soul as expensively as possible!');

//  Output.DrawString(3,19,LightGray,'Good Luck!');

  Output.DrawString(59,3,LightGray,'@<Keybindings');
  KeyBind('Wait a turn',COMMAND_WAIT);
  KeyBind('Look mode',COMMAND_LOOK);
  KeyBind('Run mode',COMMAND_RUNNING);
  KeyBind('Character screen',COMMAND_PLAYERINFO);
  KeyBind('Help',COMMAND_HELP);
  KeyBind('Fire crossbow',COMMAND_FIRE);
  KeyBind('Reload crossbow',COMMAND_CRRELOAD);
  KeyBind('Fire cannon',COMMAND_CANNON);
  KeyBind('Reload cannon',COMMAND_CARELOAD);
  KeyBind('Throw knife',COMMAND_KNIFE);
  KeyBind('Throw bomb',COMMAND_BOMB);
  KeyBind('Use fairy dust',COMMAND_FAIRYDUST);
  KeyBind('Sweep attack',COMMAND_SKILLSWEEP);
  KeyBind('Whirlwind attack',COMMAND_SKILLWHIRL);
  KeyBind('Jump attack',COMMAND_SKILLJUMP);

  Output.DrawString(59,21,LightGray,'Special attacks need the appropriate skill.',21);


  Output.DrawString(3,22,LightGray,'Press "@<a@>".."@<e@>" or <@<Enter@>>, <@<Escape@>> to continue...');

  Key := Input.GetKey([Ord('a')..Ord('e'),VKEY_ENTER,VKEY_ESCAPE]);
  if Key in [Ord('a')..Ord('e')] then RunHelp(Key-Ord('a')+1);
until Key in [VKEY_ENTER,VKEY_ESCAPE];
  UI.Draw;
end;

class procedure TBerserkText.Mortem;
var Viewer : TTextViewer;
var MText  : Text;
    Count  : byte;
    Str    : string;
begin
  Viewer := TTextViewer.Create('Berserk! mortem.txt');
  Viewer.Load('mortem.txt');
//  Viewer.Sub   := '@lPress <@LEnter@l> or <@LEscape@l> to continue...@d';
  Viewer.Run;
  Viewer.Free;
end;

class procedure TBerserkText.HOF;
var Reason   : string;
    Count    : Word;
    HOFArray : PHOFArray;
begin
  Output.Clear;
  Output.MoveCursor(1,1);
  Output.DrawString(1,2 ,DarkGray,Padded(' ---- @<Berserk! Hall of Fame : '+ModeToString(Player.Mode)+' Mode@> ',82,'-'));
  Output.DrawString(1,25,DarkGray,Padded(' ---- @lPress <@LEnter@l> or <@LEscape@l> to continue...@d ',90,'-'));
  HOFArray := brhof.HOF.GetArray(Player.Mode);

  for Count := 1 to HOFENTRIES do
   with HOFArray^[Count] do
   begin
    if Turns = 0 then Continue;
    case KillBy of
      1      : Reason := 'commited suicide';
      2..100 : Reason := 'killed by a @<'+Berserk.Lua.IndexedTable['beings',KillBy,'name']+'@>';
    else Reason := 'killed by unknown ('+IntToStr(KillBy)+')!';
    end;
    if Count = brhof.HOF.Current then
    begin
      Output.DrawString(2 ,3+Count,White,Name);
      Output.DrawString(14,3+Count,White,'survived @1 turns',[Turns]);
      Output.DrawString(35,3+Count,White,'@1 kills',[Kills]);
      Output.DrawString(49,3+Count,White,ArenaToString(Field));
      Output.DrawString(57,3+Count,White,Reason);
    end
    else
    begin
      Output.DrawString(2 ,3+Count,White,Name);
      Output.DrawString(14,3+Count,LightGray,'survived @<@1@> turns',[Turns]);
      Output.DrawString(35,3+Count,LightGray,'@<@1@> kills',[Kills]);
      Output.DrawString(49,3+Count,White,ArenaToString(Field));
      Output.DrawString(57,3+Count,LightGray,Reason);
    end;
  end;
  Input.GetKey([VKey_Enter,VKey_Escape]);
end;

class procedure TBerserkText.Night;
var Quote,Lines : Byte;
begin
  Output.Clear;
  UI.DrawFire;
  UI.Window(10,3,70,22);
  Output.MoveCursor(1,1);
  Output.CenterDrawString(40,6,LightRed,'BERSERK! Night @1',[Player.Night]);
  
  Quote := Random(Berserk.Lua['quote_count'])+1;
  
  Lines := Output.DrawString(20,8,LightGray,Berserk.Lua.IndexedTable['quotes',Quote,'text'],40);
  Output.LeftDrawString(60,8+Lines,DarkGray,'-- @<'+Berserk.Lua.IndexedTable['quotes',Quote,'author']);
  
  if Player.Night > 1 then
    Output.CenterDrawString(40,17,LightRed,'@1 kills and counting...',[Player.Kills.All]);
  Output.CenterDrawString(40,18,LightRed,'[@yc@R]ontinue or [@ys@R]ave and exit');
  if Input.GetKey([Ord('c'),Ord('s')]) = Ord('s') then Berserk.Save;
  UI.Clear;
end;

class procedure TBerserkText.RunHelp(Number : byte);
var Viewer : TTextViewer;
var MText  : Text;
    Count  : byte;
    Str    : string;
begin
  case Number of
    1 : Viewer := TTextViewer.Create('@<Berserk! Help:@> Getting Started');
    2 : Viewer := TTextViewer.Create('@<Berserk! Help:@> Tips and Tricks');
    3 : Viewer := TTextViewer.Create('@<Berserk! Help:@> Feedback');
    4 : Viewer := TTextViewer.Create('@<Berserk! Help:@> Credits');
    5 : Viewer := TTextViewer.Create('@<Berserk! Help:@> Disclaimer');
  end;
  case Number of
    1 : Viewer.Load('help'+PathDelim+'start.hlp');
    2 : Viewer.Load('help'+PathDelim+'tips.hlp');
    3 : Viewer.Load('help'+PathDelim+'feedback.hlp');
    4 : Viewer.Load('help'+PathDelim+'credits.hlp');
    5 : Viewer.Load('help'+PathDelim+'disclaim.hlp');
  end;
//  Viewer.EnterExits := True;
//  Viewer.Sub   := '@lPress <@LEnter@l> or <@LEscape@l> to continue...@d';
  Viewer.Run;
  Viewer.Free;
end;

end.

