unit brlevgen;
{$mode objfpc}
interface
uses math, sysutils, vrltools, vdungen;

type TSpawnType = (SPAWN_WEAK, SPAWN_RANGED,   SPAWN_MEDIUM,   SPAWN_STRONG,
                   SPAWN_FAST, SPAWN_SPECIAL1, SPAWN_SPECIAL2);
const SPAWNSET_STANDARD = 1;
      SPAWNSET_FOREST   = 2;
      SPAWNSET_SNOW     = 3;

// Overriden Valkyrie dungeon builder
type

{ TLevelGenerator }

TLevelGenerator = class(TDungeonBuilder)
  MonsterSet : Byte;
  // Initialization (takes the size of the level as arguments).
  constructor Create;
  // Runs the generator, basing on info from Level singleton.
  procedure Run;
  // Runs the monster spawning.
  procedure Tick;
  // Spawns a monster type from the given set
  procedure Spawn(MonsterType : TSpawnType);
  // PutCell should write CellID to coordinates (x,y).
  procedure PutCell(const Coord : TCoord2D; const CellID : Byte ); override;
  // PutCell must return the same CellID that was written to (x,y).
  function  GetCell(const Coord : TCoord2D ) : Byte; override;
  // Generates a road on the map. Random heading, random shift
  procedure CreateRoad(Horiz : Byte = 0; River : Boolean = False);
  // Tilts the map so that rivers don't look straight
  procedure Tilt(Horiz : Boolean);
end;

implementation

uses brmain, brlevel, brdata, brui, brbeing, brplayer;

constructor TLevelGenerator.Create;
begin
  inherited Create(MAP_MAXX,MAP_MAXY);
  SetWallCell (TerraID['stone_wall']);
  SetFloorCell(TerraID['grass']);
  SetDoorCell (TerraID['open_door']);
end;

procedure TLevelGenerator.Run;
var Arena : Byte;
begin
  MonsterSet := SPAWNSET_STANDARD;
  Arena := Level.Arena;
  Level.SpriteBase := 3;
  if Arena in [ARENA_BRIDGE,ARENA_RIVER] then
    if Random(2) = 1 then Arena := ARENA_FOREST else Arena := ARENA_FIELDS;
  case Arena of
    ARENA_TOWN   : begin
                     if Random(6) > 0 then CreateRoad;
                     Area.A.Create(4,3);
                     Area.B.Create(MAP_MAXX-3,MAP_MAXY-2);
                     CityDungeon(200,6,4,[TerraID['grass']],TerraID['floor'],TerraID['grass'],2);
                     if Random(4) = 0 then
                     begin
                       Transmute([TerraID['mud']],TerraID['floor']);
                       Transmute([TerraID['grass']],TerraID['mud']);
                     end;
                     Level.SpriteBase := 3;
                   end;
    ARENA_FOREST : begin
                     Sprinkle(TerraID['stones'],20);
                     case Random(10) of
                       0..6 : Sprinkle(TerraID['tree'],120);
                       7..8 : Sprinkle(TerraID['tree'],200);
                          9 : Sprinkle(TerraID['tree'],360);
                     end;
                     DrunkardWalk(20,10,TerraID['mud'],[],False);
                     if Random(4) > 0 then CreateRoad;
                     MonsterSet := SPAWNSET_FOREST;
                     Level.SpriteBase := 3;
                   end;
    ARENA_SNOW   : begin
                     Fill(TerraID['snow']);
                     Level.SpriteBase := 35;
                     case Random(5) of
                       0,1 : begin
                                DrunkardWalk(10,10,TerraID['mud'],[],False);
                                DrunkardWalk(10,10,TerraID['ice'],[],False);
                                Sprinkle(TerraID['stones'],50);
                              end;
                       2,3    : begin
                                DrunkardWalk(10,10,TerraID['mud'],[],False);
                                DrunkardWalk(10,10,TerraID['ice'],[],False);
                                DrunkardWalk(5,15,TerraID['icy_water'],[],False);
                                Sprinkle(TerraID['stones'],30);
                              end;
                       4    : begin
                                DrunkardWalk(30,10,TerraID['stones'],[],False);
                                DrunkardWalk(10,10,TerraID['ice'],[],False);
                                DrunkardWalk(5,25,TerraID['icy_water'],[],False);
                              end;
                     end;
                     MonsterSet := SPAWNSET_SNOW;
                   end;
    ARENA_FIELDS   : begin
                     case Random(5) of
                       0..2 : begin
                                DrunkardWalk(20,10,TerraID['mud'],[],False);
                                Sprinkle(TerraID['floor'],50);
                                Sprinkle(TerraID['stones'],50);
                              end;
                       3    : begin
                                Fill(TerraID['mud']);
                                DrunkardWalk(10,10,TerraID['floor'],[],False);
                                DrunkardWalk(10,10,TerraID['stones'],[],False);
                                Sprinkle(TerraID['floor'],30);
                                Sprinkle(TerraID['stones'],30);
                              end;
                       4    : begin
                                DrunkardWalk(30,10,TerraID['stones'],[],False);
                                Sprinkle(TerraID['stones'],30);
                              end;
                     end;
                   end;
  end;
  case Level.Arena of
    ARENA_FIELDS : if Random(4) > 0 then CreateRoad;
    ARENA_BRIDGE : if Random(3) = 0 then
                   begin
                     CreateRoad(2,True);
                     CreateRoad(1);
                   end
                   else
                   begin
                     CreateRoad(1,True);
                     CreateRoad(2);
                   end;
    ARENA_RIVER  : CreateRoad(0,True);
  end;
end;

procedure TLevelGenerator.Tick;
var SpecChance : Byte;
    Demon      : TBeing;
begin
  if Level.NoSpawn then
    if Level.BeingsLeft = 1 then
    begin
      Level.Cleared := True;
      UI.Msg('That must be all of them...');
      UI.Msg('...for tonight that is...');
      UI.Msg('Press <@<Enter@>>...');
      UI.Draw;
      UI.PressEnter;
      Exit;
    end else Exit;

  if Level.Mode = modeEndless then
    if Level.TickCount >= NIGHTDURATION then
    begin
      Demon := Level.Spawn('demon',Player.Night+2);
      UI.Msg(Demon.getName+' has appeared!');
      UI.Msg('Now kill all of them!');
      Level.NoSpawn := True;
      Exit;
    end;
    
  if Level.Mode = modeMassacre then SpecChance := Min(20,Level.SpawnLevel*3)
                               else SpecChance := Min(20,(Player.Night-1)*5+Level.SpawnLevel*2+1);
  if Level.TickCount mod 10 = 0 then
  begin
    if Level.TickCount > (Level.SpawnLevel*Level.SpawnLevel)*100 then
      Inc(Level.SpawnLevel);
    if Random(100) < 13+Level.SpawnLevel*2+Player.Night*2 then
      case Random(100)+Level.SpawnLevel+Player.Night*2 of
        0..74     : Spawn(SPAWN_WEAK);
        75..86    : Spawn(SPAWN_RANGED);
        87..98    : Spawn(SPAWN_MEDIUM);
        99        : if Level.Mode = modeMassacre then
                    begin
                      Demon := Level.Spawn('demon',Level.SpawnLevel+2);
                      UI.Msg(Demon.getName+' has appeared!');
                    end;
        101..10000: case Random(SpecChance) of
                        0..9 : Spawn(SPAWN_STRONG);
                      10..16 : Spawn(SPAWN_FAST);
                      17..18 : Spawn(SPAWN_SPECIAL1);
                          19 : Spawn(SPAWN_SPECIAL2);
                    end;
      end;
  end;
end;

procedure TLevelGenerator.Spawn(MonsterType : TSpawnType);
begin
  case MonsterType of
    SPAWN_WEAK     : Level.Spawn('beast');
    SPAWN_RANGED   : if MonsterSet = SPAWNSET_SNOW then Level.Spawn('ice_devil')
                                                   else Level.Spawn('imp');
    SPAWN_MEDIUM   : if MonsterSet = SPAWNSET_FOREST then Level.Spawn('scavenger')
                                                     else Level.Spawn('bulldemon');
    SPAWN_STRONG   : if MonsterSet = SPAWNSET_SNOW then Level.Spawn('yeti')
                                                   else Level.Spawn('mandagore');
    SPAWN_FAST     : Level.Spawn('phasehound');
    SPAWN_SPECIAL1 : if MonsterSet = SPAWNSET_FOREST then
                     case Random(4) of
                       0    : begin Level.Spawn('skeleton',2*(Random(4)+1));Level.Spawn('wraith'); end;
                       1..3 : Level.Spawn('treespirit');
                     end
                     else
                     begin Level.Spawn('skeleton',2*(Random(4)+1));Level.Spawn('wraith'); end;
    SPAWN_SPECIAL2 : if MonsterSet = SPAWNSET_SNOW then Level.Spawn('blizzard')
                                                   else Level.Spawn('defiler');
  end;
end;

procedure TLevelGenerator.PutCell(const Coord : TCoord2D; const CellID : Byte );
begin
  Level.Cell[ Coord ] := CellID;
end;

function TLevelGenerator.GetCell(const Coord : TCoord2D ) : Byte;
begin
//  if not Level.properCoord( NewCoord2D( x, y ) ) then CritError( IntToStr(x) + '!!!' + IntToStr(y) );
  Exit( Level.Cell[ Coord ] );
end;

procedure TLevelGenerator.CreateRoad(Horiz : Byte = 0; River : Boolean = False);
var Shift : ShortInt;
    Ran   : byte;
    W,C,T : byte;
    BlockSet : Set of Byte;
    SubCell : Byte;
begin
  BlockSet := [];
  SubCell := 0;
  if not River then
  begin
    BlockSet := [TerraID['shallow_water'],TerraID['deep_water']];
    SubCell := TerraID['bridge'];
  end;

  Ran := Random(4);
  w := 2+Random(2);
  
  if Random(4) = 0 then T := TerraID['floor'] else T := TerraID['mud'];
  if River then T := TerraID['shallow_water'];

  if Random(3) = 0 then Inc(w);
  if Ran = 2 then Ran := Random(4);
  
  if River and (W > 2) then W := 2; // prevents non-passable river
  
  if Horiz = 1 then Ran := 0;
  if Horiz = 2 then Ran := 3;

  if Ran in [0,1,2] then
  begin
    Shift := Random(11)-5;
    for C := 1 to W do
    begin
      if River then
        if (C > 1) and (C < W) then T := TerraID['deep_water'] else T := TerraID['shallow_water'];
      PlotLine(NewCoord2D(1,12+Shift+C),True,T,0,BlockSet,SubCell);
    end;
    if River then Tilt(True);
  end;
  if Ran in [2,3] then
  begin
    Shift := Random(21)-10;
    for C := 1 to W do
    begin
      if River then
        if (C > 1) and (C < W) then T := TerraID['deep_water'] else T := TerraID['shallow_water'];
      PlotLine(NewCoord2D(24+Shift+C,1),False,T,0,BlockSet,SubCell);
    end;
    if River then Tilt(False);
  end
end;

procedure TLevelGenerator.Tilt(Horiz : Boolean);
var x,y,c : Byte;
    TiltV : ShortInt;
  procedure AdjustTilt;
  begin
    if Random(5) = 0 then
    case TiltV of
      -1,1 : TiltV := 0;
       0   : TiltV := Random(2)*2-1;
    end;
  end;
begin
  TiltV := 0;
  if Horiz then
    for x := 1 to MAP_MAXX do
    begin
      AdjustTilt;
      if TiltV = 1 then
      begin
        c := GetCell(NewCoord2D(x,1));
        for y := 1 to MAP_MAXY-1 do
          PutCell(NewCoord2D(x,y),GetCell(NewCoord2D(x,y+1)));
        PutCell(NewCoord2D(x,MAP_MAXY),c);
      end;
      if TiltV = -1 then
      begin
        c := GetCell(NewCoord2D(x,MAP_MAXY));
        for y := MAP_MAXY downto 2 do
          PutCell(NewCoord2D(x,y),GetCell(NewCoord2D(x,y-1)));
        PutCell(NewCoord2D(x,1),c);
      end;
    end
  else
  for y := 1 to MAP_MAXY do
    begin
      AdjustTilt;
      if TiltV = 1 then
      begin
        c := GetCell(NewCoord2D(1,y));
        for x := 1 to MAP_MAXX-1 do
          PutCell(NewCoord2D(x,y),GetCell(NewCoord2D(x+1,y)));
        PutCell(NewCoord2D(MAP_MAXX,y),c);
      end;
      if TiltV = -1 then
      begin
        c := GetCell(NewCoord2D(MAP_MAXX,y));
        for x := MAP_MAXX downto 2 do
          PutCell(NewCoord2D(x,y),GetCell(NewCoord2D(x-1,y)));
        PutCell(NewCoord2D(1,y),c);
      end;
    end;

end;


end.

