require "core:toolbox"
require "core:const"

core = {}

-- global utility functions --
function core.declare (name, initval)
  rawset(_G, name, initval or false)
end

-- make_id function --
function core.make_id(name)
  return string.lower(string.gsub(name," ","_"))
end

-- storage registering function --
function core.register( storage, element )
	element.name = element.name or "error"
	element.id = element.id or core.make_id(element.name)
	if not storage.__counter then storage.__counter = 0 end
	if element.nid ~= 0 then
		storage.__counter = storage.__counter + 1
		element.nid = storage.__counter
	end
	storage[element.id] = element
	storage[element.nid] = element
	--define(element.id, element.nid)
end

-- logging --
core.log = core_log

Being = { }

function Being.call_hook(ptr,id,hook_name,...)
	if beings[id][hook_name] then
		return beings[id][hook_name]( Being:handle(ptr), unpack(arg) )
	end
	return nil
end

Being.__flags_mt = {
	__newindex = function (this, key, value)
		if type(key) == "table" then
			for _,v in ipairs(key) do
				being_flags_set( this.__ptr, v, value )
			end
		else
			being_flags_set( this.__ptr, key, value )
		end
	end,
	__index = function (this, key)
		return being_flags_get( this.__ptr, key )
	end,
}

function Being:handle(ptr)
	if ptr == nil then return nil end
	local object = { 
		__ptr = ptr, 
		flags = { __ptr = ptr } 
	}
	setmetatable( object.flags, Being.__flags_mt )

	return setmetatable( object, {
		__newindex = function (this, k, v)
			this:set_property(k,v)
		end,
		__index = function (this, k)
			local r = rawget(self,k) 
			if r then return r end
			return this:get_property(k)
		end,
	} )
end

function Being:set_property(key, value)
	local name = "PROP_"..string.upper(key)
	being_property_set( self.__ptr, _G[name], value )
end

function Being:get_property(key)
	if not rawget(self,"__ptr") then error("__ptr absent from table!") end
	local name = "PROP_"..string.upper(key)
	return being_property_get( self.__ptr, _G[name] )
end

function Being:get_target_pos()
	return self.target_x, self.target_y
end

function Being:get_target()
	return Level.get_being(self.target_x, self.target_y)
end

function Being:get_pos()
	return self.pos_x, self.pos_y
end

function Being:apply_damage( amount, dtype )
	dtype = dtype or 0
	being_apply_damage( self.__ptr, amount, dtype )
end

function Being:move( x, y )
	being_move( self.__ptr, x, y )
end

function Being:send_missile( x, y, mtype )
	being_send_missile( self.__ptr, x, y, mtype )
end

-- extremely dangerous! --
function Being:die()
	being_die( self.__ptr )
end

Level = {}
function Level.get_being( x, y )
	return Being:handle(level_get_being( x, y))
end

function Level.summon( id, x, y, level )
	return Being:handle(level_summon( id, x, y, level ))
end

function Level.get_cell( x, y )
	return cells[ level_get_cell( x, y ) ].id
end

function Level.set_cell( cell, x, y )
	return level_set_cell( cells[cell].nid, x, y )
end

function Level.clamp_area( area )
	if area == nil then 
		area = { x1 = 1, y1 = 1, x2 = MAP_MAXX, y2 = MAP_MAXY }
	else
		area.x1 = math.max(1, area.x1)
		area.x2 = math.min(MAP_MAXX, area.x2)
		area.y1 = math.max(1, area.y1)
		area.y2 = math.min(MAP_MAXY, area.y2)
	end
	return area
end
	

function Level.find_cell( condition, area )
	area = Level.clamp_area( area );
	for x=area.x1,area.x2 do
		for y=area.y1,area.y2 do
			if condition(x,y) then return x,y end
		end
	end
end

function Level.for_all_cells( action, area )
	area = Level.clamp_area( area );
	for x=area.x1,area.x2 do
		for y=area.y1,area.y2 do
			action(x,y)
		end
	end
end

function Level.random_coord( condition, area )
	area = Level.clamp_area( area );
	if type(condition) == "nil" then
		return math.random(area.x1,area.x2), math.random(area.y1,area.y2)
	else
		local count = 0
		local x, y
		repeat
			if count == 100 then return end
			x = math.random(area.x1,area.x2)
			y = math.random(area.y1,area.y2)
			count = count + 1
		until condition(x,y)
		return x,y
	end
end

function Level.explosion( x,y, color, range, strength, delay, dtype )
	color = color or RED
	range = range or 2
	strength = strength or 0
	delay = delay or 50
	dtype = dtype or DAMAGE_FIRE
	level_explosion( x,y, color, range, strength, delay, dtype )
end

ui = {}
ui.msg = ui_msg
Player = {}
area = {}

function area.around( x, y, range )
	return { x1 = x - range, y1 = y - range, 
			 x2 = x + range, y2 = y + range }
end

function core.initialize()
	Player = Level.get_being(1)
end


-- Metatable hack that disallows usage of undeclared variables --
setmetatable(_G, {
  __newindex = function (_, n)
  error("attempt to write to undeclared variable "..n, 2)
  end,
  __index = function (_, n)
  error("attempt to read undeclared variable "..n, 2)
  end,
})
