coord = {}

coord.__mt = {
	__unm     = coord.unm,
	__add     = coord.add,
	__sub     = coord.sub,
	__mul     = coord.mul,
	__eq      = coord.eq,
	__call    = coord.get,
	__tostring= coord.tostring,
}

function coord.new( nx, ny )
	return setmetatable( { x = nx or 0, y = ny or 0 }, coord.__mt )
end

function coord.unm( c )
	return coord.new( -c.x, -c.y )
end

function coord.add( lhs, rhs )
	return coord.new( lhs.x + rhs.x, lhs.y + rhs.y )
end

function coord.sub( lhs, rhs )
	return coord.new( lhs.x - rhs.x, lhs.y - rhs.y )
end

function coord.mul( lhs, rhs )
	if type(rhs) == "table" then
		if type(lhs) == "table" then
			return coord.new( lhs.x * rhs.x, lhs.y * rhs.y )
		else
			return coord.new( lhs * rhs.x, lhs * rhs.y )
		end
	else
		return coord.new( lhs.x * rhs, lhs.y * rhs )
	end
end

function coord.eq( lhs, rhs )
	return lhs.x == rhs.x and lhs.y == rhs.y
end

function coord.get( c )
	return c.x, c.y
end

function coord.tostring( c )
	return '('..c.x..','..c.y..')'
end

function coord.abs( c )
	return coord.new( math.abs(c.x), math.abs(c.y) )
end

function coord.distance( c1, c2 )
	local ax, ay = math.abs(c1.x-c2.x), math.abs(c1.y-c2.y)
	return math.floor( math.min(ax,ay) / 2 + math.max(ax,ay) )
end
