core.declare("cell_prototype")
core.declare("Cells")
core.declare("cells")

cells = {}

function Cells( c )
	if c.proto then
		table.prototype( c, c.proto )
	end
	core.register( cells, c )
end

cell_prototype = {
	picture    = '?',
	color      = RED,
	dpicture   = ' ',
	dcolor     = DARKGRAY,
	dr         = 0,
	blood_id   = "",
	destroy_id = "",
	act_id     = "",
	sprite     = 0,
	spriteb    = 0,
	move_cost  = 100,
	flags      = {},
}

Cells{
	proto      = cell_prototype,
	name       = 'grass',
	picture    = '.',
	color      = GREEN,
	blood_id   = 'blood',
	spriteb    = 3,
	move_cost  = 105,
}

Cells{
	proto      = cell_prototype,
	name       = 'stone wall',
	picture    = '#',
	color      = LIGHTGRAY,
	dpicture   = '.',
	dr         = 40,
	blood_id   = 'bloody_stone_wall',
	destroy_id = 'floor',
	spriteb    = 4,
	flags      = { TF_NOMOVE, TF_NOSIGHT },
}

Cells{
	proto      = cell_prototype,
	name       = 'bloody stone wall',
	picture    = '#',
	color      = RED,
	dpicture   = '.',
	dr         = 40,
	destroy_id = 'blood',
	spriteb    = 4,
	sprite     = 9,
	flags      = { TF_NOMOVE, TF_NOSIGHT },
}

Cells{
	proto      = cell_prototype,
	name       = 'blood',
	picture    = '.',
	color      = RED,
	blood_id   = 'pool_of_blood',
	sprite     = 13, 
	move_cost  = 105, 
}

Cells{
	proto      = cell_prototype,
	name       = 'pool of blood',
	picture    = ':',
	color      = RED,
	sprite     = 14, 
	move_cost  = 105, 
}

Cells{
	proto      = cell_prototype,
	name       = 'bloody corpse',
	picture    = '%',
	color      = RED,
	sprite     = 15, 
	move_cost  = 110, 
	flags      = { TF_HIGHLIGHT },
}

Cells{
	proto      = cell_prototype,
	name       = 'closed door',
	picture    = '+',
	color      = BROWN,
	act_id     = 'open_door', 
	spriteb    = 21, 
	sprite     = 7, 
}

Cells{
	proto      = cell_prototype,
	name       = 'open door',
	picture    = '/',
	color      = BROWN,
	dr         = 20, 
	destroy_id = 'floor', 
	act_id     = 'closed_door', 
	spriteb    = 21, 
	sprite     = 8, 
	move_cost  = 110, 
}

Cells{
	proto      = cell_prototype,
	name       = 'floor',
	picture    = '.',
	color      = LIGHTGRAY,
	blood_id   = 'blood', 
	spriteb    = 21, 
	move_cost  = 90, 
}

Cells{
	proto      = cell_prototype,
	name       = 'mud',
	picture    = '.',
	color      = BROWN,
	blood_id   = 'blood', 
	sprite     = 12, 
}

Cells{
	proto      = cell_prototype,
	name       = 'wooden wall',
	picture    = '#',
	color      = BROWN,
	dpicture   = '#',
	dr         = 30, 
	blood_id   = 'bloody_wooden_wall',
	destroy_id = 'floor', 
	spriteb    = 6, 
	flags      = { TF_NOMOVE, TF_NOSIGHT },
}

Cells{
	proto      = cell_prototype,
	name       = 'bloody wooden wall',
	picture    = '#',
	color      = RED,
	dpicture   = '#',
	dr         = 30, 
	destroy_id = 'blood', 
	spriteb    = 6, 
	sprite     = 9, 
	flags      = { TF_NOMOVE, TF_NOSIGHT },
}

Cells{
	proto      = cell_prototype,
	name       = 'tree',
	picture    = 'T',
	color      = GREEN,
	dpicture   = '.',
	dr         = 20, 
	blood_id   = 'bloody_tree',
	destroy_id = 'grass', 
	spriteb    = 3, 
	sprite     = 23, 
	is_tree    = true,
	flags      = { TF_NOMOVE, TF_NOSIGHT },
}

Cells{
	proto      = cell_prototype,
	name       = 'bloody tree',
	picture    = 'T',
	color      = RED,
	dpicture   = '.',
	dr         = 20, 
	destroy_id = 'blood', 
	spriteb    = 3, 
	sprite     = 24, 
	is_tree    = true,
	flags      = { TF_NOMOVE, TF_NOSIGHT },
}

Cells{
	proto      = cell_prototype,
	name       = 'stones',
	picture    = '#',
	color      = LIGHTGRAY,
	dpicture   = '.',
	dr         = 40, 
	blood_id   = 'bloody_stones',
	destroy_id = 'grass', 
	sprite     = 10, 
	flags      = { TF_NOMOVE, TF_NOSIGHT },
}

Cells{
	proto      = cell_prototype,
	name       = 'bloody stones',
	picture    = '#',
	color      = RED,
	dpicture   = '.',
	dr         = 40, 
	destroy_id = 'blood', 
	sprite     = 11, 
	flags      = { TF_NOMOVE, TF_NOSIGHT },
}

Cells{
	proto      = cell_prototype,
	name       = 'shallow water',
	picture    = '=',
	color      = LIGHTBLUE,
	dpicture   = '=',
	spriteb    = 25, 
	move_cost  = 200, 
	flags      = { TF_WATER, TF_NOCORPSE },

}

Cells{
	proto      = cell_prototype,
	name       = 'deep water',
	picture    = '=',
	color      = BLUE,
	dpicture   = '=',
	spriteb    = 27, 
	flags      = { TF_NOMOVE, TF_WATER, TF_NOCORPSE },
}

Cells{
	proto      = cell_prototype,
	name       = 'bridge',
	picture    = '-',
	color      = BROWN,
	dpicture   = '-',
	blood_id   = 'bloody_bridge',
	spriteb    = 22, 
}

Cells{
	proto      = cell_prototype,
	name       = 'bloody bridge',
	picture    = '-',
	color      = RED,
	dpicture   = '-',
	spriteb    = 22, 
	sprite     = 13, 
}

Cells{
	proto      = cell_prototype,
	name       = 'snow',
	picture    = '.',
	color      = WHITE,
	blood_id   = 'blood', 
	spriteb    = 35, 
	move_cost  = 120, 
}

Cells{
	proto      = cell_prototype,
	name       = 'ice',
	picture    = '-',
	color      = LIGHTCYAN,
	dpicture   = '.',
	spriteb    = 36, 
	move_cost  = 150, 
	flags      = { TF_ICE },
}

Cells{
	proto      = cell_prototype,
	name       = 'icy water',
	picture    = '=',
	color      = LIGHTBLUE,
	dpicture   = '=',
	spriteb    = 41, 
	move_cost  =  200, 
	flags      = { TF_WATER, TF_FREEZE },
}